/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.engine.properties.shrinking.UniqueShrinkable;

public class UniqueGenerator<T>
implements RandomGenerator<T> {
    private static final long MAX_MISSES = 10000L;
    private final RandomGenerator<T> toFilter;
    private final Set<T> usedValues = ConcurrentHashMap.newKeySet();

    public UniqueGenerator(RandomGenerator<T> toFilter) {
        this.toFilter = toFilter;
    }

    public Shrinkable<T> next(Random random) {
        return this.nextUntilAccepted(random, r -> {
            Shrinkable next = this.toFilter.next(r);
            return new UniqueShrinkable<T>(next, this.usedValues);
        });
    }

    public String toString() {
        return String.format("Unique [%s]", this.toFilter);
    }

    private Shrinkable<T> nextUntilAccepted(Random random, Function<Random, Shrinkable<T>> fetchShrinkable) {
        Shrinkable<T> next;
        long count = 0L;
        while (this.usedValues.contains((next = fetchShrinkable.apply(random)).value())) {
            if (++count <= 10000L) continue;
            throw new TooManyFilterMissesException(String.format("%s missed more than %s times.", this.toString(), 10000L));
        }
        this.usedValues.add(next.value());
        return next;
    }
}

