/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.arbitraries.Range;
import net.jqwik.engine.properties.shrinking.ShrinkableBigDecimal;

public class RandomDecimalGenerators {
    public static RandomGenerator<BigDecimal> bigDecimals(Range<BigDecimal> range, int scale, BigDecimal[] partitionPoints) {
        if (scale < 0) {
            throw new JqwikException(String.format("Scale [%s] must be positive.", scale));
        }
        if (range.isSingular()) {
            return ignored -> Shrinkable.unshrinkable(range.min);
        }
        return RandomDecimalGenerators.partitionedGenerator(range, scale, partitionPoints);
    }

    private static RandomGenerator<BigDecimal> partitionedGenerator(Range<BigDecimal> range, int scale, BigDecimal[] partitionPoints) {
        List<RandomGenerator<BigDecimal>> generators = RandomDecimalGenerators.createPartitions(range, scale, partitionPoints);
        if (generators.size() == 1) {
            return generators.get(0);
        }
        return random -> ((RandomGenerator)generators.get(random.nextInt(generators.size()))).next(random);
    }

    private static List<RandomGenerator<BigDecimal>> createPartitions(Range<BigDecimal> range, int scale, BigDecimal[] partitionPoints) {
        ArrayList<RandomGenerator<BigDecimal>> partitions = new ArrayList<RandomGenerator<BigDecimal>>();
        Arrays.sort(partitionPoints);
        BigDecimal lower = (BigDecimal)range.min;
        for (BigDecimal partitionPoint : partitionPoints) {
            BigDecimal upper = partitionPoint;
            if (upper.compareTo(lower) <= 0) continue;
            if (upper.compareTo((BigDecimal)range.max) >= 0) break;
            partitions.add(RandomDecimalGenerators.createBaseGenerator(lower, upper, scale, range));
            lower = upper;
        }
        partitions.add(RandomDecimalGenerators.createBaseGenerator(lower, (BigDecimal)range.max, scale, range));
        return partitions;
    }

    private static RandomGenerator<BigDecimal> createBaseGenerator(BigDecimal minGenerate, BigDecimal maxGenerate, int scale, Range<BigDecimal> range) {
        BigInteger scaledMin = minGenerate.scaleByPowerOfTen(scale).toBigInteger();
        BigInteger scaledMax = maxGenerate.scaleByPowerOfTen(scale).toBigInteger();
        return random -> {
            BigInteger randomIntegral = RandomDecimalGenerators.randomIntegral(random, scaledMin, scaledMax);
            BigDecimal randomDecimal = new BigDecimal(randomIntegral, scale);
            return new ShrinkableBigDecimal(randomDecimal, range, scale);
        };
    }

    private static BigInteger randomIntegral(Random random, BigInteger min, BigInteger max) {
        BigInteger rawValue;
        BigInteger value;
        BigInteger range = max.subtract(min);
        int bits = range.bitLength();
        while ((value = (rawValue = new BigInteger(bits, random)).add(min)).compareTo(min) < 0 || value.compareTo(max) > 0) {
        }
        return value;
    }

    public static BigDecimal[] calculateDefaultPartitionPoints(int genSize, BigDecimal min, BigDecimal max) {
        int partitionPoint = Math.max(genSize / 2, 10);
        BigDecimal upperPartitionPoint = BigDecimal.valueOf(partitionPoint).min(max);
        BigDecimal lowerPartitionPoint = BigDecimal.valueOf(partitionPoint).negate().max(min);
        return new BigDecimal[]{lowerPartitionPoint, upperPartitionPoint};
    }
}

