/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.engine.properties.shrinking.FilteredShrinkable;

public class FilteredGenerator<T>
implements RandomGenerator<T> {
    private static final long MAX_MISSES = 10000L;
    private final RandomGenerator<T> toFilter;
    private final Predicate<T> filterPredicate;

    public FilteredGenerator(RandomGenerator<T> toFilter, Predicate<T> filterPredicate) {
        this.toFilter = toFilter;
        this.filterPredicate = filterPredicate;
    }

    public Shrinkable<T> next(Random random) {
        return this.nextUntilAccepted(random, arg_0 -> this.toFilter.next(arg_0));
    }

    public String toString() {
        return String.format("Filtering [%s]", this.toFilter);
    }

    private Shrinkable<T> nextUntilAccepted(Random random, Function<Random, Shrinkable<T>> fetchShrinkable) {
        long count = 0L;
        do {
            Shrinkable<T> next;
            if (!this.filterPredicate.test((next = fetchShrinkable.apply(random)).value())) continue;
            return new FilteredShrinkable<T>(next, this.filterPredicate);
        } while (++count <= 10000L);
        throw new TooManyFilterMissesException(String.format("%s missed more than %s times.", this.toString(), 10000L));
    }
}

