/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import net.jqwik.api.ExhaustiveGenerator;

public class WithSamplesExhaustiveGenerator<T>
implements ExhaustiveGenerator<T> {
    private final T[] samples;
    private final ExhaustiveGenerator<T> base;

    public WithSamplesExhaustiveGenerator(ExhaustiveGenerator<T> base, T[] samples) {
        this.samples = samples;
        this.base = base;
    }

    public boolean isUnique() {
        return this.base.isUnique();
    }

    public long maxCount() {
        return this.base.maxCount() + (long)this.samples.length;
    }

    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final AtomicInteger countDeliveredSamples = new AtomicInteger(0);
            Iterator<T> iterator = WithSamplesExhaustiveGenerator.access$000(WithSamplesExhaustiveGenerator.this).iterator();

            @Override
            public boolean hasNext() {
                if (this.samplesAvailable()) {
                    return true;
                }
                return this.iterator.hasNext();
            }

            private boolean samplesAvailable() {
                return this.countDeliveredSamples.get() < WithSamplesExhaustiveGenerator.this.samples.length;
            }

            @Override
            public T next() {
                if (this.samplesAvailable()) {
                    return WithSamplesExhaustiveGenerator.this.samples[this.countDeliveredSamples.getAndIncrement()];
                }
                return this.iterator.next();
            }
        };
    }

    static /* synthetic */ ExhaustiveGenerator access$000(WithSamplesExhaustiveGenerator x0) {
        return x0.base;
    }
}

