/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.TooManyFilterMissesException;

public class UniqueExhaustiveGenerator<T>
implements ExhaustiveGenerator<T> {
    private static final long MAX_MISSES = 10000L;
    private final ExhaustiveGenerator<T> base;

    public UniqueExhaustiveGenerator(ExhaustiveGenerator<T> base) {
        this.base = base;
    }

    public boolean isUnique() {
        return true;
    }

    public long maxCount() {
        return this.base.maxCount();
    }

    public Iterator<T> iterator() {
        final Iterator mappedIterator = this.base.iterator();
        final ConcurrentHashMap.KeySetView usedValues = ConcurrentHashMap.newKeySet();
        return new Iterator<T>(){
            T next = this.findNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.next = this.findNext();
                return result;
            }

            private T findNext() {
                long count = 0L;
                do {
                    if (!mappedIterator.hasNext()) {
                        return null;
                    }
                    Object next = mappedIterator.next();
                    if (usedValues.contains(next)) continue;
                    usedValues.add(next);
                    return next;
                } while (++count <= 10000L);
                String message = String.format("Uniqueness filter missed more than %s times.", 10000L);
                throw new TooManyFilterMissesException(message);
            }
        };
    }
}

