/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.support.Combinatorics;
import net.jqwik.engine.support.MathSupport;

class PermutationExhaustiveGenerator<T>
implements ExhaustiveGenerator<List<T>> {
    private final List<T> values;
    private final Long maxCount;

    public PermutationExhaustiveGenerator(List<T> values, Long maxCount) {
        this.values = values;
        this.maxCount = maxCount;
    }

    static <T> Optional<Long> calculateMaxCount(List<T> values) {
        try {
            long choices = MathSupport.factorial(values.size());
            if (choices > ExhaustiveGenerators.MAXIMUM_ACCEPTED_MAX_COUNT || choices < 0L) {
                return Optional.empty();
            }
            return Optional.of(choices);
        }
        catch (ArithmeticException ae) {
            return Optional.empty();
        }
    }

    public long maxCount() {
        return this.maxCount;
    }

    public Iterator<List<T>> iterator() {
        return Combinatorics.listPermutations(this.values);
    }
}

