/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.support.Combinatorics;

public class FlatMappedExhaustiveGenerator<U, T>
implements ExhaustiveGenerator<U> {
    private final List<T> baseValues;
    private final long maxCount;
    private final Function<T, Arbitrary<U>> mapper;

    public static <T, U> Optional<Long> calculateMaxCounts(List<T> baseValues, Function<T, Arbitrary<U>> mapper) {
        long choices = 0L;
        for (T baseValue : baseValues) {
            Optional exhaustive = mapper.apply(baseValue).exhaustive();
            if (!exhaustive.isPresent()) {
                return Optional.empty();
            }
            if ((choices += ((ExhaustiveGenerator)exhaustive.get()).maxCount()) <= ExhaustiveGenerators.MAXIMUM_ACCEPTED_MAX_COUNT) continue;
            return Optional.empty();
        }
        return Optional.of(choices);
    }

    public FlatMappedExhaustiveGenerator(List<T> baseValues, long maxCount, Function<T, Arbitrary<U>> mapper) {
        this.baseValues = baseValues;
        this.maxCount = maxCount;
        this.mapper = mapper;
    }

    public long maxCount() {
        return this.maxCount;
    }

    public Iterator<U> iterator() {
        List iterators = this.baseValues.stream().map(baseValue -> (Iterable)this.mapper.apply(baseValue).exhaustive().get()).collect(Collectors.toList());
        return Combinatorics.concat(iterators);
    }
}

