/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.TooManyFilterMissesException;

public class FilteredExhaustiveGenerator<T>
implements ExhaustiveGenerator<T> {
    private static final long MAX_MISSES = 10000L;
    private final ExhaustiveGenerator<T> toFilter;
    private final Predicate<T> filter;

    public FilteredExhaustiveGenerator(ExhaustiveGenerator<T> toFilter, Predicate<T> filter) {
        this.toFilter = toFilter;
        this.filter = filter;
    }

    public boolean isUnique() {
        return this.toFilter.isUnique();
    }

    public long maxCount() {
        return this.toFilter.maxCount();
    }

    public Iterator<T> iterator() {
        final Iterator mappedIterator = this.toFilter.iterator();
        return new Iterator<T>(){
            T next = this.findNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.next = this.findNext();
                return result;
            }

            private T findNext() {
                long count = 0L;
                do {
                    if (!mappedIterator.hasNext()) {
                        return null;
                    }
                    Object next = mappedIterator.next();
                    if (!FilteredExhaustiveGenerator.this.filter.test(next)) continue;
                    return next;
                } while (++count <= 10000L);
                String message = String.format("Filter missed more than %s times.", 10000L);
                throw new TooManyFilterMissesException(message);
            }
        };
    }
}

