/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.CombinedExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.FlatMappedExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.IterableBasedExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.ListExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.PermutationExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.SetExhaustiveGenerator;

public class ExhaustiveGenerators {
    public static long MAXIMUM_ACCEPTED_MAX_COUNT = Integer.MAX_VALUE;

    public static <T> Optional<ExhaustiveGenerator<T>> choose(List<T> values) {
        return ExhaustiveGenerators.fromIterable(values, values.size());
    }

    public static Optional<ExhaustiveGenerator<Character>> choose(char[] characters) {
        ArrayList<Character> validCharacters = new ArrayList<Character>(characters.length);
        for (char character : characters) {
            validCharacters.add(Character.valueOf(character));
        }
        return ExhaustiveGenerators.choose(validCharacters);
    }

    public static <T extends Enum<T>> Optional<ExhaustiveGenerator<T>> choose(Class<T> enumClass) {
        return ExhaustiveGenerators.choose(Arrays.asList(enumClass.getEnumConstants()));
    }

    public static <T> Optional<ExhaustiveGenerator<T>> fromIterable(Iterable<T> iterator, long maxCount) {
        return Optional.of(new IterableBasedExhaustiveGenerator<T>(iterator, maxCount));
    }

    public static <T> Optional<ExhaustiveGenerator<List<T>>> list(Arbitrary<T> elementArbitrary, int minSize, int maxSize) {
        Optional<Long> optionalMaxCount = ListExhaustiveGenerator.calculateMaxCount(elementArbitrary, minSize, maxSize);
        return optionalMaxCount.map(maxCount -> {
            ListExhaustiveGenerator exhaustiveGenerator = new ListExhaustiveGenerator(elementArbitrary, (Long)maxCount, minSize, maxSize);
            Optional exhaustive = elementArbitrary.exhaustive();
            if (exhaustive.isPresent() && ((ExhaustiveGenerator)exhaustive.get()).isUnique()) {
                Predicate<List> allElementsUnique = list -> list.size() == new HashSet(list).size();
                return exhaustiveGenerator.filter(allElementsUnique);
            }
            return exhaustiveGenerator;
        });
    }

    public static Optional<ExhaustiveGenerator<String>> strings(Arbitrary<Character> characterArbitrary, int minLength, int maxLength) {
        return ExhaustiveGenerators.list(characterArbitrary, minLength, maxLength).map(listGenerator -> listGenerator.map(listOfChars -> listOfChars.stream().map(String::valueOf).collect(Collectors.joining())));
    }

    public static <T> Optional<ExhaustiveGenerator<Set<T>>> set(Arbitrary<T> elementArbitrary, int minSize, int maxSize) {
        Optional<Long> optionalMaxCount = SetExhaustiveGenerator.calculateMaxCount(elementArbitrary, minSize, maxSize);
        return optionalMaxCount.map(maxCount -> new SetExhaustiveGenerator(elementArbitrary, (long)maxCount, minSize, maxSize));
    }

    public static <R> Optional<ExhaustiveGenerator<R>> combine(List<Arbitrary<Object>> arbitraries, Function<List<Object>, R> combinator) {
        Optional<Long> optionalMaxCount = CombinedExhaustiveGenerator.calculateMaxCount(arbitraries);
        return optionalMaxCount.map(maxCount -> new CombinedExhaustiveGenerator((Long)maxCount, arbitraries, combinator));
    }

    public static <T> Optional<ExhaustiveGenerator<List<T>>> shuffle(List<T> values) {
        Optional<Long> optionalMaxCount = PermutationExhaustiveGenerator.calculateMaxCount(values);
        return optionalMaxCount.map(maxCount -> new PermutationExhaustiveGenerator(values, (Long)maxCount));
    }

    public static <U, T> Optional<ExhaustiveGenerator<U>> flatMap(ExhaustiveGenerator<T> base, Function<T, Arbitrary<U>> mapper) {
        List allBaseValues = StreamSupport.stream(base.spliterator(), false).collect(Collectors.toList());
        Optional<Long> optionalMaxCount = FlatMappedExhaustiveGenerator.calculateMaxCounts(allBaseValues, mapper);
        return optionalMaxCount.map(maxCount -> new FlatMappedExhaustiveGenerator(allBaseValues, (long)maxCount, mapper));
    }
}

