/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.function.Consumer;
import java.util.function.Function;
import net.jqwik.api.JqwikException;

public class Range<T extends Comparable> {
    public final T min;
    public final T max;

    public static <T extends Comparable> Range<T> of(T min, T max) {
        if (min.compareTo(max) > 0) {
            throw new JqwikException(String.format("Min value [%s] must not be greater that max value [%s].", min, max));
        }
        return new Range<T>(min, max);
    }

    private Range(T min, T max) {
        this.min = min;
        this.max = max;
    }

    public boolean isSingular() {
        return this.min.compareTo(this.max) == 0;
    }

    public boolean includes(T value) {
        return value.compareTo(this.min) >= 0 && value.compareTo(this.max) <= 0;
    }

    public void ifIncluded(T value, Consumer<T> consumer) {
        if (this.includes(value)) {
            consumer.accept(value);
        }
    }

    public <U extends Comparable> Range<U> map(Function<T, U> mapper) {
        return Range.of((Comparable)mapper.apply(this.min), (Comparable)mapper.apply(this.max));
    }

    public String toString() {
        return String.format("%s..%s", this.min, this.max);
    }
}

