/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

abstract class MultivalueArbitraryBase<T>
extends AbstractArbitraryBase {
    protected Arbitrary<T> elementArbitrary;
    protected int minSize = 0;
    protected int maxSize = 255;

    protected MultivalueArbitraryBase(Arbitrary<T> elementArbitrary) {
        this.elementArbitrary = elementArbitrary;
    }

    protected RandomGenerator<List<T>> createListGenerator(int genSize) {
        RandomGenerator<T> elementGenerator = this.elementGenerator(this.elementArbitrary, genSize);
        List samples = this.edgeCases(new ArrayList());
        return RandomGenerators.list(elementGenerator, this.minSize, this.maxSize, this.cutoffSize(genSize)).withEdgeCases(genSize, samples);
    }

    protected int cutoffSize(int genSize) {
        return RandomGenerators.defaultCutoffSize(this.minSize, this.maxSize, genSize);
    }

    protected <C extends Collection> List<Shrinkable<C>> edgeCases(C sample) {
        return Stream.of(sample).filter(l -> l.size() >= this.minSize).filter(l -> this.maxSize == 0 || l.size() <= this.maxSize).map(Shrinkable::unshrinkable).collect(Collectors.toList());
    }

    protected RandomGenerator<T> elementGenerator(Arbitrary<T> elementArbitrary, int genSize) {
        return elementArbitrary.generator(genSize);
    }
}

