/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.engine.properties.arbitraries.Range;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomIntegralGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableBigInteger;

class IntegralGeneratingArbitrary
implements Arbitrary<BigInteger> {
    BigInteger min;
    BigInteger max;

    IntegralGeneratingArbitrary(BigInteger defaultMin, BigInteger defaultMax) {
        this.min = defaultMin;
        this.max = defaultMax;
    }

    public RandomGenerator<BigInteger> generator(int genSize) {
        BigInteger[] partitionPoints = RandomIntegralGenerators.calculateDefaultPartitionPoints(genSize, this.min, this.max);
        return this.createGenerator(partitionPoints, genSize);
    }

    public Optional<ExhaustiveGenerator<BigInteger>> exhaustive() {
        BigInteger maxCount = this.max.subtract(this.min).add(BigInteger.ONE);
        if (maxCount.compareTo(BigInteger.valueOf(ExhaustiveGenerators.MAXIMUM_ACCEPTED_MAX_COUNT)) > 0) {
            return Optional.empty();
        }
        return ExhaustiveGenerators.fromIterable(() -> new RangeIterator(), maxCount.longValueExact());
    }

    private RandomGenerator<BigInteger> createGenerator(BigInteger[] partitionPoints, int genSize) {
        List edgeCases = Arrays.stream(this.edgeCases()).filter(aBigInt -> aBigInt.compareTo(this.min) >= 0 && aBigInt.compareTo(this.max) <= 0).map(anInt -> new ShrinkableBigInteger((BigInteger)anInt, Range.of(this.min, this.max))).collect(Collectors.toList());
        return RandomGenerators.bigIntegers(this.min, this.max, partitionPoints).withEdgeCases(genSize, edgeCases);
    }

    private BigInteger[] edgeCases() {
        return new BigInteger[]{BigInteger.valueOf(-10L), BigInteger.valueOf(-5L), BigInteger.valueOf(-4L), BigInteger.valueOf(-3L), BigInteger.valueOf(-2L), BigInteger.valueOf(-1L), BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.valueOf(10L), BigInteger.valueOf(5L), BigInteger.valueOf(4L), BigInteger.valueOf(3L), BigInteger.valueOf(2L), BigInteger.valueOf(1L), this.min, this.max};
    }

    class RangeIterator
    implements Iterator<BigInteger> {
        BigInteger current;

        RangeIterator() {
            this.current = IntegralGeneratingArbitrary.this.min;
        }

        @Override
        public boolean hasNext() {
            return this.current.compareTo(IntegralGeneratingArbitrary.this.max) <= 0;
        }

        @Override
        public BigInteger next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BigInteger next = this.current;
            this.current = this.current.add(BigInteger.ONE);
            return next;
        }
    }
}

