/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.configurators.SelfConfiguringArbitrary;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class FrequencyOfArbitrary<T>
implements Arbitrary<T>,
SelfConfiguringArbitrary<T> {
    private final List<Tuple.Tuple2<Integer, Arbitrary<T>>> frequencies = new ArrayList<Tuple.Tuple2<Integer, Arbitrary<T>>>();

    public FrequencyOfArbitrary(List<Tuple.Tuple2<Integer, Arbitrary<T>>> frequencies) {
        frequencies.stream().filter(f -> (Integer)f.get1() > 0).forEach(this.frequencies::add);
        if (this.frequencies.isEmpty()) {
            throw new JqwikException("At least one frequency must be above 0");
        }
    }

    public RandomGenerator<T> generator(int genSize) {
        return RandomGenerators.frequency(this.frequencies).flatMap(Function.identity(), genSize);
    }

    public Optional<ExhaustiveGenerator<T>> exhaustive() {
        return ExhaustiveGenerators.choose(this.allArbitraries()).flatMap(generator -> ExhaustiveGenerators.flatMap(generator, Function.identity()));
    }

    private List<Arbitrary<T>> allArbitraries() {
        return this.frequencies.stream().map(Tuple.Tuple2::get2).collect(Collectors.toList());
    }

    public Arbitrary<T> configure(ArbitraryConfigurator configurator, TypeUsage targetType) {
        this.frequencies.replaceAll(f -> {
            Arbitrary configuredArbitrary = f.get2() instanceof SelfConfiguringArbitrary ? ((SelfConfiguringArbitrary)f.get2()).configure(configurator, targetType) : configurator.configure((Arbitrary)f.get2(), targetType);
            return Tuple.of((Object)f.get1(), (Object)configuredArbitrary);
        });
        return this;
    }
}

