/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class DefaultStringArbitrary
extends AbstractArbitraryBase
implements StringArbitrary {
    private List<Arbitrary<Character>> characterArbitraries = new ArrayList<Arbitrary<Character>>();
    private int minLength = 0;
    private int maxLength = 255;

    private Arbitrary<Character> defaultCharacterArbitrary() {
        return Arbitraries.chars().all().filter(c -> !DefaultStringArbitrary.isNoncharacter(c.charValue()) && !DefaultStringArbitrary.isPrivateUseCharacter(c.charValue()));
    }

    public static boolean isNoncharacter(int codepoint) {
        if (codepoint >= 64976 && codepoint <= 65007) {
            return true;
        }
        return codepoint == 65534 || codepoint == 65535;
    }

    public static boolean isPrivateUseCharacter(int codepoint) {
        return codepoint >= 57344 && codepoint <= 63743;
    }

    public RandomGenerator<String> generator(int genSize) {
        int cutoffLength = RandomGenerators.defaultCutoffSize(this.minLength, this.maxLength, genSize);
        List samples = Arrays.stream(new String[]{""}).filter(s -> s.length() >= this.minLength && s.length() <= this.maxLength).map(Shrinkable::unshrinkable).collect(Collectors.toList());
        return RandomGenerators.strings(this.randomCharacterGenerator(), this.minLength, this.maxLength, cutoffLength).withEdgeCases(genSize, samples);
    }

    public Optional<ExhaustiveGenerator<String>> exhaustive() {
        return ExhaustiveGenerators.strings(this.effectiveCharacterArbitrary(), this.minLength, this.maxLength);
    }

    public StringArbitrary ofMinLength(int minLength) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.minLength = minLength;
        return clone;
    }

    public StringArbitrary ofMaxLength(int maxLength) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.maxLength = maxLength;
        return clone;
    }

    public StringArbitrary withChars(char ... chars) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.addChars(chars);
        return clone;
    }

    public StringArbitrary withCharRange(char from, char to) {
        if (from == '\u0000' && to == '\u0000') {
            return this;
        }
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.addCharRange(from, to);
        return clone;
    }

    public StringArbitrary ascii() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitraries.add((Arbitrary<Character>)Arbitraries.chars().ascii());
        return clone;
    }

    public StringArbitrary alpha() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.addCharRange('a', 'z');
        clone.addCharRange('A', 'Z');
        return clone;
    }

    public StringArbitrary numeric() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.addCharRange('0', '9');
        return clone;
    }

    public StringArbitrary whitespace() {
        return this.withChars('\t', '\n', '\u000b', '\f', '\r', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '\u1680', '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u2028', '\u2029', '\u205f', '\u3000');
    }

    public StringArbitrary all() {
        return this.withCharRange('\u0000', '\uffff');
    }

    private void addCharRange(char from, char to) {
        this.characterArbitraries.add((Arbitrary<Character>)Arbitraries.chars().between(from, to));
    }

    private void addChars(char[] chars) {
        this.characterArbitraries.add((Arbitrary<Character>)Arbitraries.of((char[])chars));
    }

    private RandomGenerator<Character> randomCharacterGenerator() {
        return this.effectiveCharacterArbitrary().generator(1);
    }

    private Arbitrary<Character> effectiveCharacterArbitrary() {
        if (this.characterArbitraries.isEmpty()) {
            return this.defaultCharacterArbitrary();
        }
        Arbitrary<Character> first = this.characterArbitraries.get(0);
        Arbitrary[] rest = this.characterArbitraries.subList(1, this.characterArbitraries.size()).toArray(new Arbitrary[this.characterArbitraries.size() - 1]);
        return Arbitraries.oneOf(first, (Arbitrary[])rest);
    }
}

