/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.Optional;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.IntegralGeneratingArbitrary;

public class DefaultLongArbitrary
extends AbstractArbitraryBase
implements LongArbitrary {
    private static final long DEFAULT_MIN = Long.MIN_VALUE;
    private static final long DEFAULT_MAX = Long.MAX_VALUE;
    private final IntegralGeneratingArbitrary generatingArbitrary = new IntegralGeneratingArbitrary(BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE));

    public RandomGenerator<Long> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize).map(BigInteger::longValueExact);
    }

    public Optional<ExhaustiveGenerator<Long>> exhaustive() {
        return this.generatingArbitrary.exhaustive().map(generator -> generator.map(BigInteger::longValueExact));
    }

    public LongArbitrary greaterOrEqual(long min) {
        DefaultLongArbitrary clone = (DefaultLongArbitrary)this.typedClone();
        clone.generatingArbitrary.min = BigInteger.valueOf(min);
        return clone;
    }

    public LongArbitrary lessOrEqual(long max) {
        DefaultLongArbitrary clone = (DefaultLongArbitrary)this.typedClone();
        clone.generatingArbitrary.max = BigInteger.valueOf(max);
        return clone;
    }
}

