/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigDecimal;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.FloatArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.DecimalGeneratingArbitrary;

public class DefaultFloatArbitrary
extends AbstractArbitraryBase
implements FloatArbitrary {
    private static final float DEFAULT_MIN = -3.4028235E38f;
    private static final float DEFAULT_MAX = Float.MAX_VALUE;
    private final DecimalGeneratingArbitrary generatingArbitrary = new DecimalGeneratingArbitrary(this.toBigDecimal(-3.4028235E38f), this.toBigDecimal(Float.MAX_VALUE));

    public RandomGenerator<Float> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize).map(BigDecimal::floatValue);
    }

    public FloatArbitrary greaterOrEqual(float min) {
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.generatingArbitrary.min = this.toBigDecimal(min);
        return clone;
    }

    public FloatArbitrary lessOrEqual(float max) {
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.generatingArbitrary.max = this.toBigDecimal(max);
        return clone;
    }

    public FloatArbitrary ofScale(int scale) {
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.generatingArbitrary.scale = scale;
        return clone;
    }

    private BigDecimal toBigDecimal(float value) {
        return BigDecimal.valueOf(value);
    }
}

