/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Optional;
import java.util.stream.IntStream;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.CharacterArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class DefaultCharacterArbitrary
extends AbstractArbitraryBase
implements CharacterArbitrary {
    public static final int MAX_ASCII_CODEPOINT = 127;
    private char min = '\u0000';
    private char max = '\u0000';

    public RandomGenerator<Character> generator(int genSize) {
        return RandomGenerators.chars(this.min, this.max);
    }

    public Optional<ExhaustiveGenerator<Character>> exhaustive() {
        long maxCount = this.max + '\u0001' - this.min;
        return ExhaustiveGenerators.fromIterable(() -> IntStream.range(this.min, this.max + '\u0001').iterator(), maxCount).map(optionalGenerator -> optionalGenerator.map(anInt -> Character.valueOf((char)anInt.intValue())));
    }

    public CharacterArbitrary between(char min, char max) {
        DefaultCharacterArbitrary clone = (DefaultCharacterArbitrary)this.typedClone();
        clone.min = min;
        clone.max = max;
        return clone;
    }

    public CharacterArbitrary ascii() {
        return this.between('\u0000', '\u007f');
    }

    public CharacterArbitrary all() {
        return this.between('\u0000', '\uffff');
    }

    public CharacterArbitrary digit() {
        return this.between('0', '9');
    }
}

