/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.Optional;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.ByteArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.IntegralGeneratingArbitrary;

public class DefaultByteArbitrary
extends AbstractArbitraryBase
implements ByteArbitrary {
    private static final byte DEFAULT_MIN = -128;
    private static final byte DEFAULT_MAX = 127;
    private final IntegralGeneratingArbitrary generatingArbitrary = new IntegralGeneratingArbitrary(BigInteger.valueOf(-128L), BigInteger.valueOf(127L));

    public RandomGenerator<Byte> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize).map(BigInteger::byteValueExact);
    }

    public Optional<ExhaustiveGenerator<Byte>> exhaustive() {
        return this.generatingArbitrary.exhaustive().map(generator -> generator.map(BigInteger::byteValueExact));
    }

    public ByteArbitrary greaterOrEqual(byte min) {
        DefaultByteArbitrary clone = (DefaultByteArbitrary)this.typedClone();
        clone.generatingArbitrary.min = BigInteger.valueOf(min);
        return clone;
    }

    public ByteArbitrary lessOrEqual(byte max) {
        DefaultByteArbitrary clone = (DefaultByteArbitrary)this.typedClone();
        clone.generatingArbitrary.max = BigInteger.valueOf(max);
        return clone;
    }
}

