/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.Optional;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.IntegralGeneratingArbitrary;

public class DefaultBigIntegerArbitrary
extends AbstractArbitraryBase
implements BigIntegerArbitrary {
    private static final BigInteger DEFAULT_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger DEFAULT_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private final IntegralGeneratingArbitrary generatingArbitrary = new IntegralGeneratingArbitrary(DEFAULT_MIN, DEFAULT_MAX);

    public RandomGenerator<BigInteger> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize);
    }

    public Optional<ExhaustiveGenerator<BigInteger>> exhaustive() {
        return this.generatingArbitrary.exhaustive();
    }

    public BigIntegerArbitrary greaterOrEqual(BigInteger min) {
        DefaultBigIntegerArbitrary clone = (DefaultBigIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary.min = min == null ? DEFAULT_MIN : min;
        return clone;
    }

    public BigIntegerArbitrary lessOrEqual(BigInteger max) {
        DefaultBigIntegerArbitrary clone = (DefaultBigIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary.max = max == null ? DEFAULT_MAX : max;
        return clone;
    }
}

