/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomGenerator;
import net.jqwik.engine.properties.arbitraries.Range;
import net.jqwik.engine.properties.arbitraries.randomized.RandomDecimalGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableBigDecimal;

class DecimalGeneratingArbitrary
implements Arbitrary<BigDecimal> {
    private static final int DEFAULT_SCALE = 2;
    BigDecimal min;
    BigDecimal max;
    int scale = 2;

    DecimalGeneratingArbitrary(BigDecimal defaultMin, BigDecimal defaultMax) {
        this.min = defaultMin;
        this.max = defaultMax;
    }

    public RandomGenerator<BigDecimal> generator(int genSize) {
        BigDecimal[] partitionPoints = RandomDecimalGenerators.calculateDefaultPartitionPoints(genSize, this.min, this.max);
        return this.decimalGenerator(partitionPoints, genSize);
    }

    private RandomGenerator<BigDecimal> decimalGenerator(BigDecimal[] partitionPoints, int genSize) {
        BigDecimal smallest = BigDecimal.ONE.movePointLeft(this.scale);
        BigDecimal[] sampleValues = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ONE.negate(), smallest, smallest.negate(), this.min, this.max};
        List samples = Arrays.stream(sampleValues).distinct().filter(aDecimal -> aDecimal.compareTo(this.min) >= 0 && aDecimal.compareTo(this.max) <= 0).map(value -> new ShrinkableBigDecimal((BigDecimal)value, Range.of(this.min, this.max), this.scale)).collect(Collectors.toList());
        return RandomGenerators.bigDecimals(this.min, this.max, this.scale, partitionPoints).withEdgeCases(genSize, samples);
    }
}

