/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.platform.engine.reporting.ReportEntry;

public class StatisticsCollector {
    public static final String KEY_STATISTICS = "collected statistics";
    private static ThreadLocal<StatisticsCollector> collector = ThreadLocal.withInitial(StatisticsCollector::new);
    private final Map<List<Object>, Integer> counts = new HashMap<List<Object>, Integer>();

    public static void clearAll() {
        collector.remove();
    }

    public static StatisticsCollector get() {
        return collector.get();
    }

    public static void report(Consumer<ReportEntry> reporter) {
        StatisticsCollector collector = StatisticsCollector.get();
        if (collector.isEmpty()) {
            return;
        }
        reporter.accept(collector.createReportEntry());
    }

    private boolean isEmpty() {
        return this.counts.isEmpty();
    }

    public Map<List<Object>, Integer> getCounts() {
        return this.counts;
    }

    public ReportEntry createReportEntry() {
        StringBuilder statistics = new StringBuilder();
        int sum = this.counts.values().stream().mapToInt(aCount -> aCount).sum();
        List statisticsEntries = this.counts.entrySet().stream().sorted((e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue())).filter(entry -> !((List)entry.getKey()).equals(Collections.emptyList())).map(entry -> new StatisticsEntry(this.displayKey((List)entry.getKey()), (double)((Integer)entry.getValue()).intValue() * 100.0 / (double)sum)).collect(Collectors.toList());
        int maxKeyLength = statisticsEntries.stream().mapToInt(entry -> ((StatisticsEntry)entry).name.length()).max().orElse(0);
        boolean fullNumbersOnly = !statisticsEntries.stream().anyMatch(entry -> ((StatisticsEntry)entry).percentage < 1.0);
        statisticsEntries.stream().forEach(statsEntry -> statistics.append(String.format("%n    %1$-" + maxKeyLength + "s : %2$s %%", ((StatisticsEntry)statsEntry).name, this.displayPercentage(((StatisticsEntry)statsEntry).percentage, fullNumbersOnly))));
        return ReportEntry.from((String)KEY_STATISTICS, (String)statistics.toString());
    }

    private String displayPercentage(double percentage, boolean fullNumbersOnly) {
        if (fullNumbersOnly) {
            return String.valueOf(Math.round(percentage));
        }
        return String.valueOf((double)Math.round(percentage * 100.0) / 100.0);
    }

    private String displayKey(List<Object> key) {
        return key.stream().map(Object::toString).collect(Collectors.joining(" "));
    }

    public void collect(Object ... values) {
        List key = Collections.emptyList();
        if (values != null) {
            key = Arrays.stream(values).filter(Objects::nonNull).collect(Collectors.toList());
        }
        int count = this.counts.computeIfAbsent(key, any -> 0);
        this.counts.put(key, ++count);
    }

    static class StatisticsEntry {
        private final String name;
        private final double percentage;

        StatisticsEntry(String name, double percentage) {
            this.name = name;
            this.percentage = percentage;
        }
    }
}

