/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.Provide;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.configurators.RegisteredArbitraryConfigurators;
import net.jqwik.engine.facades.TypeUsageImpl;
import net.jqwik.engine.properties.AmbiguousArbitraryException;
import net.jqwik.engine.properties.ArbitraryResolver;
import net.jqwik.engine.properties.RegisteredArbitraryConfigurer;
import net.jqwik.engine.properties.RegisteredArbitraryResolver;
import net.jqwik.engine.providers.RegisteredArbitraryProviders;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.MethodParameter;
import org.junit.platform.commons.support.HierarchyTraversalMode;

public class PropertyMethodArbitraryResolver
implements ArbitraryResolver {
    private final Class<?> containerClass;
    private final Object testInstance;
    private final RegisteredArbitraryResolver registeredArbitraryResolver;
    private final RegisteredArbitraryConfigurer registeredArbitraryConfigurer;

    public PropertyMethodArbitraryResolver(Class<?> containerClass, Object testInstance) {
        this(containerClass, testInstance, new RegisteredArbitraryResolver(RegisteredArbitraryProviders.getProviders()), new RegisteredArbitraryConfigurer(RegisteredArbitraryConfigurators.getConfigurators()));
    }

    public PropertyMethodArbitraryResolver(Class<?> containerClass, Object testInstance, RegisteredArbitraryResolver registeredArbitraryResolver, RegisteredArbitraryConfigurer registeredArbitraryConfigurer) {
        this.containerClass = containerClass;
        this.testInstance = testInstance;
        this.registeredArbitraryResolver = registeredArbitraryResolver;
        this.registeredArbitraryConfigurer = registeredArbitraryConfigurer;
    }

    @Override
    public Set<Arbitrary<?>> forParameter(MethodParameter parameter) {
        TypeUsage typeUsage = TypeUsageImpl.forParameter(parameter);
        return this.createForType(typeUsage);
    }

    private Set<Arbitrary<?>> createForType(TypeUsage targetType) {
        HashSet<Object> resolvedArbitraries = new HashSet<Object>();
        String generatorName = targetType.findAnnotation(ForAll.class).map(ForAll::value).orElse("");
        Optional<Method> optionalCreator = this.findArbitraryGeneratorByName(targetType, generatorName);
        if (optionalCreator.isPresent()) {
            Arbitrary createdArbitrary = (Arbitrary)JqwikReflectionSupport.invokeMethodPotentiallyOuter(optionalCreator.get(), this.testInstance, new Object[0]);
            resolvedArbitraries.add(createdArbitrary);
        } else if (generatorName.isEmpty()) {
            resolvedArbitraries.addAll(this.resolveRegisteredArbitrary(targetType));
            if (resolvedArbitraries.isEmpty()) {
                this.findFirstFitArbitrary(targetType).ifPresent(resolvedArbitraries::add);
            }
        }
        return resolvedArbitraries.stream().map(arbitrary -> this.configure((Arbitrary<?>)arbitrary, targetType)).collect(Collectors.toSet());
    }

    private Arbitrary<?> configure(Arbitrary<?> createdArbitrary, TypeUsage targetType) {
        return this.registeredArbitraryConfigurer.configure(createdArbitrary, targetType);
    }

    private Optional<Method> findArbitraryGeneratorByName(TypeUsage typeUsage, String generatorToFind) {
        if (generatorToFind.isEmpty()) {
            return Optional.empty();
        }
        Function<Method, String> generatorNameSupplier = method -> {
            Provide generateAnnotation = method.getDeclaredAnnotation(Provide.class);
            return generateAnnotation.value();
        };
        TypeUsage targetArbitraryType = TypeUsage.of(Arbitrary.class, (TypeUsage[])new TypeUsage[]{typeUsage});
        return JqwikReflectionSupport.findGeneratorMethod(generatorToFind, this.containerClass, Provide.class, generatorNameSupplier, targetArbitraryType);
    }

    private Optional<Arbitrary<?>> findFirstFitArbitrary(TypeUsage typeUsage) {
        return this.findArbitraryCreator(typeUsage).map(creator -> (Arbitrary)JqwikReflectionSupport.invokeMethodPotentiallyOuter(creator, this.testInstance, new Object[0]));
    }

    private Optional<Method> findArbitraryCreator(TypeUsage typeUsage) {
        TypeUsage targetArbitraryType = TypeUsage.of(Arbitrary.class, (TypeUsage[])new TypeUsage[]{typeUsage});
        List<Method> creators = JqwikReflectionSupport.findMethodsPotentiallyOuter(this.containerClass, JqwikReflectionSupport.isGeneratorMethod(targetArbitraryType, Provide.class), HierarchyTraversalMode.BOTTOM_UP);
        if (creators.size() > 1) {
            throw new AmbiguousArbitraryException(typeUsage, creators);
        }
        return creators.stream().findFirst();
    }

    private Set<Arbitrary<?>> resolveRegisteredArbitrary(TypeUsage parameterType) {
        return this.registeredArbitraryResolver.resolve(parameterType, this::createForType);
    }
}

