/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.support.JqwikAnnotationSupport;
import net.jqwik.engine.support.MethodParameter;

public class TypeUsageImpl
implements TypeUsage {
    private static Map<Type, TypeUsageImpl> resolved = new ConcurrentHashMap<Type, TypeUsageImpl>();
    static final String WILDCARD = "?";
    private final Class<?> rawType;
    private final String typeVariable;
    private final List<Annotation> annotations;
    private final List<TypeUsage> typeArguments = new ArrayList<TypeUsage>();
    private final List<TypeUsage> upperBounds = new ArrayList<TypeUsage>();
    private final List<TypeUsage> lowerBounds = new ArrayList<TypeUsage>();

    public static TypeUsage forParameter(MethodParameter parameter) {
        TypeUsageImpl typeUsage = new TypeUsageImpl(TypeUsageImpl.extractRawType(parameter.getType()), TypeUsageImpl.extractTypeVariable(parameter.getType()), parameter.findAllAnnotations());
        typeUsage.addTypeArguments(TypeUsageImpl.extractTypeArguments(parameter));
        typeUsage.addUpperBounds(TypeUsageImpl.extractUpperBounds(parameter.getType()));
        typeUsage.addLowerBounds(TypeUsageImpl.extractLowerBounds(parameter.getType()));
        return typeUsage;
    }

    static TypeUsageImpl forParameterizedType(Type parameterizedType) {
        return TypeUsageImpl.resolveOrCreate(parameterizedType, TypeUsageImpl.extractRawType(parameterizedType), TypeUsageImpl.extractTypeVariable(parameterizedType), Collections.emptyList(), typeUsage -> {
            typeUsage.addTypeArguments(TypeUsageImpl.extractPlainTypeArguments(parameterizedType));
            typeUsage.addUpperBounds(TypeUsageImpl.extractUpperBounds(parameterizedType));
            typeUsage.addLowerBounds(TypeUsageImpl.extractLowerBounds(parameterizedType));
        });
    }

    static TypeUsageImpl forWildcard(WildcardType wildcardType) {
        return TypeUsageImpl.resolveOrCreate(wildcardType, Object.class, WILDCARD, TypeUsageImpl.extractAnnotations(wildcardType), typeUsage -> {
            typeUsage.addUpperBounds(TypeUsageImpl.extractUpperBounds(wildcardType));
            typeUsage.addLowerBounds(TypeUsageImpl.extractLowerBounds(wildcardType));
        });
    }

    private static TypeUsageImpl resolveOrCreate(Type type, Class rawType, String typeVariable, List<Annotation> annotations, Consumer<TypeUsageImpl> processTypeUsage) {
        Optional<TypeUsageImpl> alreadyResolved = TypeUsageImpl.alreadyResolvedIn(type);
        if (alreadyResolved.isPresent()) {
            return alreadyResolved.get();
        }
        TypeUsageImpl typeUsage = new TypeUsageImpl(rawType, typeVariable, annotations);
        resolved.put(type, typeUsage);
        processTypeUsage.accept(typeUsage);
        return typeUsage;
    }

    private static TypeUsageImpl forAnnotatedType(AnnotatedType annotatedType) {
        TypeUsageImpl typeUsage = new TypeUsageImpl(TypeUsageImpl.extractRawType(annotatedType.getType()), TypeUsageImpl.extractTypeVariable(annotatedType.getType()), TypeUsageImpl.extractAnnotations(annotatedType));
        typeUsage.addTypeArguments(TypeUsageImpl.extractPlainTypeArguments(annotatedType));
        typeUsage.addUpperBounds(TypeUsageImpl.extractUpperBounds(annotatedType.getType()));
        typeUsage.addLowerBounds(TypeUsageImpl.extractLowerBounds(annotatedType.getType()));
        return typeUsage;
    }

    private static Optional<TypeUsageImpl> alreadyResolvedIn(Type type) {
        return Optional.ofNullable(resolved.get(type));
    }

    private static List<TypeUsage> extractTypeArguments(MethodParameter parameter) {
        if (parameter.isAnnotatedParameterized()) {
            return TypeUsageImpl.extractAnnotatedTypeArguments(parameter.getAnnotatedType());
        }
        return TypeUsageImpl.extractPlainTypeArguments(parameter.getType());
    }

    private static List<Annotation> extractAnnotations(Object parameterizedType) {
        if (parameterizedType instanceof AnnotatedElement) {
            return JqwikAnnotationSupport.findAllAnnotations((AnnotatedElement)parameterizedType);
        }
        return Collections.emptyList();
    }

    private static String extractTypeVariable(Type parameterizedType) {
        if (parameterizedType instanceof WildcardType) {
            return WILDCARD;
        }
        if (parameterizedType instanceof TypeVariable) {
            return ((TypeVariable)parameterizedType).getName();
        }
        return null;
    }

    private static List<TypeUsage> extractUpperBounds(Type parameterizedType) {
        if (parameterizedType instanceof TypeVariable) {
            return Arrays.stream(((TypeVariable)parameterizedType).getBounds()).map(TypeUsage::forType).collect(Collectors.toList());
        }
        if (parameterizedType instanceof WildcardType) {
            return TypeUsageImpl.extractUpperBounds((WildcardType)parameterizedType);
        }
        return new ArrayList<TypeUsage>();
    }

    private static List<TypeUsage> extractUpperBounds(WildcardType wildcardType) {
        return Arrays.stream(wildcardType.getUpperBounds()).map(TypeUsage::forType).collect(Collectors.toList());
    }

    private static List<TypeUsage> extractLowerBounds(Type parameterizedType) {
        if (parameterizedType instanceof WildcardType) {
            return TypeUsageImpl.extractLowerBounds((WildcardType)parameterizedType);
        }
        return Collections.emptyList();
    }

    private static List<TypeUsage> extractLowerBounds(WildcardType wildcardType) {
        return Arrays.stream(wildcardType.getLowerBounds()).map(TypeUsage::forType).collect(Collectors.toList());
    }

    private static Class<?> extractRawType(Type parameterizedType) {
        if (parameterizedType instanceof Class) {
            return (Class)parameterizedType;
        }
        if (parameterizedType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)parameterizedType).getRawType();
        }
        return Object.class;
    }

    private static List<TypeUsage> extractPlainTypeArguments(Object parameterizedType) {
        if (parameterizedType instanceof AnnotatedParameterizedType) {
            return TypeUsageImpl.extractAnnotatedTypeArguments((AnnotatedParameterizedType)parameterizedType);
        }
        if (parameterizedType instanceof ParameterizedType) {
            return Arrays.stream(((ParameterizedType)parameterizedType).getActualTypeArguments()).map(TypeUsage::forType).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<TypeUsage> extractAnnotatedTypeArguments(AnnotatedParameterizedType annotatedType) {
        return Arrays.stream(annotatedType.getAnnotatedActualTypeArguments()).map(TypeUsageImpl::forAnnotatedType).collect(Collectors.toList());
    }

    TypeUsageImpl(Class<?> rawType, String typeVariable, List<Annotation> annotations) {
        this.rawType = rawType;
        this.typeVariable = typeVariable;
        this.annotations = annotations;
    }

    void addTypeArguments(List<TypeUsage> typeArguments) {
        this.typeArguments.addAll(typeArguments);
    }

    void addLowerBounds(List<TypeUsage> lowerBounds) {
        this.lowerBounds.addAll(lowerBounds);
    }

    void addUpperBounds(List<TypeUsage> upperBounds) {
        this.upperBounds.addAll(upperBounds);
    }

    public List<TypeUsage> getUpperBounds() {
        return this.upperBounds;
    }

    public List<TypeUsage> getLowerBounds() {
        return this.lowerBounds;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    private boolean hasUpperBoundBeyondObject() {
        if (this.upperBounds.size() > 1) {
            return true;
        }
        return this.upperBounds.size() == 1 && !this.upperBounds.get(0).isOfType(Object.class);
    }

    private boolean hasLowerBounds() {
        return this.lowerBounds.size() > 0;
    }

    public boolean isWildcard() {
        return this.typeVariable != null && this.typeVariable.equals(WILDCARD);
    }

    public boolean isTypeVariable() {
        return this.typeVariable != null && !this.isWildcard();
    }

    public boolean isTypeVariableOrWildcard() {
        return this.isWildcard() || this.isTypeVariable();
    }

    public List<TypeUsage> getTypeArguments() {
        return this.typeArguments;
    }

    public boolean isOfType(Class<?> aRawType) {
        if (this.isTypeVariableOrWildcard()) {
            return false;
        }
        return this.rawType == aRawType;
    }

    public boolean canBeAssignedTo(TypeUsage targetType) {
        if (targetType.isTypeVariableOrWildcard()) {
            return TypeUsageImpl.canBeAssignedToUpperBounds(this, targetType) && TypeUsageImpl.canBeAssignedToLowerBounds(this, targetType);
        }
        if (this.boxedTypeMatches(targetType.getRawType(), this.rawType)) {
            return true;
        }
        if (this.boxedTypeMatches(this.rawType, targetType.getRawType())) {
            return true;
        }
        if (targetType.getRawType().isAssignableFrom(this.rawType)) {
            if (this.allTypeArgumentsCanBeAssigned(this.getTypeArguments(), targetType.getTypeArguments())) {
                return true;
            }
            return this.findSuperType(targetType.getRawType()).isPresent();
        }
        return false;
    }

    private static boolean canBeAssignedToUpperBounds(TypeUsage sourceType, TypeUsage targetType) {
        if (sourceType.isTypeVariableOrWildcard()) {
            return sourceType.getUpperBounds().stream().allMatch(upperBound -> TypeUsageImpl.canBeAssignedToUpperBounds(upperBound, targetType));
        }
        return targetType.getUpperBounds().stream().allMatch(arg_0 -> ((TypeUsage)sourceType).canBeAssignedTo(arg_0));
    }

    private static boolean canBeAssignedToLowerBounds(TypeUsage sourceType, TypeUsage targetType) {
        if (sourceType.isTypeVariableOrWildcard()) {
            return sourceType.getLowerBounds().stream().allMatch(lowerBound -> TypeUsageImpl.canBeAssignedToLowerBounds(lowerBound, targetType));
        }
        return targetType.getLowerBounds().stream().allMatch(lowerBound -> lowerBound.canBeAssignedTo(sourceType));
    }

    private boolean allTypeArgumentsCanBeAssigned(List<TypeUsage> providedTypeArguments, List<TypeUsage> targetTypeArguments) {
        if (providedTypeArguments.size() == 0) {
            return true;
        }
        if (targetTypeArguments.size() == 0) {
            return true;
        }
        if (targetTypeArguments.size() != providedTypeArguments.size()) {
            return false;
        }
        for (int i = 0; i < targetTypeArguments.size(); ++i) {
            TypeUsage targetTypeArgument;
            TypeUsage providedTypeArgument = providedTypeArguments.get(i);
            if (providedTypeArgument.canBeAssignedTo(targetTypeArgument = targetTypeArguments.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isGeneric() {
        return this.typeArguments.size() > 0;
    }

    public boolean isEnum() {
        return this.getRawType().isEnum();
    }

    public boolean isArray() {
        return this.getRawType().isArray();
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType) {
        return this.annotations.stream().filter(annotation -> annotation.annotationType().equals(annotationType)).map(annotationType::cast).findFirst();
    }

    public <A extends Annotation> boolean isAnnotated(Class<A> annotationType) {
        return this.findAnnotation(annotationType).isPresent();
    }

    public boolean isAssignableFrom(Class<?> providedClass) {
        return TypeUsage.of(providedClass, (TypeUsage[])new TypeUsage[0]).canBeAssignedTo((TypeUsage)this);
    }

    public Optional<TypeUsage> getComponentType() {
        Class<?> componentType = this.rawType.getComponentType();
        if (componentType != null) {
            return Optional.of(TypeUsage.of(componentType, (TypeUsage[])new TypeUsage[0]));
        }
        return Optional.empty();
    }

    private boolean boxedTypeMatches(Class<?> providedType, Class<?> targetType) {
        if (providedType.equals(Long.class) && targetType.equals(Long.TYPE)) {
            return true;
        }
        if (providedType.equals(Integer.class) && targetType.equals(Integer.TYPE)) {
            return true;
        }
        if (providedType.equals(Short.class) && targetType.equals(Short.TYPE)) {
            return true;
        }
        if (providedType.equals(Byte.class) && targetType.equals(Byte.TYPE)) {
            return true;
        }
        if (providedType.equals(Character.class) && targetType.equals(Character.TYPE)) {
            return true;
        }
        if (providedType.equals(Double.class) && targetType.equals(Double.TYPE)) {
            return true;
        }
        if (providedType.equals(Float.class) && targetType.equals(Float.TYPE)) {
            return true;
        }
        return providedType.equals(Boolean.class) && targetType.equals(Boolean.TYPE);
    }

    private Optional<TypeUsageImpl> findSuperType(Class<?> typeToFind) {
        return this.findSuperTypeIn(typeToFind, this.rawType);
    }

    private Optional<TypeUsageImpl> findSuperTypeIn(Class<?> typeToFind, Class<?> rawType) {
        ArrayList<AnnotatedType> supertypes = new ArrayList<AnnotatedType>();
        if (rawType.getSuperclass() != null) {
            supertypes.add(rawType.getAnnotatedSuperclass());
        }
        supertypes.addAll(Arrays.asList(rawType.getAnnotatedInterfaces()));
        for (AnnotatedType type : supertypes) {
            if (!TypeUsageImpl.extractRawType(type.getType()).equals(typeToFind)) continue;
            return Optional.of(TypeUsageImpl.forAnnotatedType(type));
        }
        for (AnnotatedType type : supertypes) {
            TypeUsageImpl typeUsage = TypeUsageImpl.forAnnotatedType(type);
            Optional<TypeUsageImpl> nestedFound = typeUsage.findSuperType(typeToFind);
            if (!nestedFound.isPresent()) continue;
            return nestedFound;
        }
        return Optional.empty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TypeUsageImpl other = (TypeUsageImpl)obj;
        if (!other.getRawType().equals(this.getRawType())) {
            return false;
        }
        if (!other.getTypeArguments().equals(this.getTypeArguments())) {
            return false;
        }
        if (!other.getAnnotations().equals(this.getAnnotations())) {
            return false;
        }
        if (other.isWildcard() && this.isWildcard()) {
            if (!other.lowerBounds.equals(this.lowerBounds)) {
                return false;
            }
            if (!other.upperBounds.equals(this.upperBounds)) {
                return false;
            }
        }
        if (other.isTypeVariable() && this.isTypeVariable()) {
            if (!other.typeVariable.equals(this.typeVariable)) {
                return false;
            }
            return other.upperBounds.equals(this.upperBounds);
        }
        return true;
    }

    public int hashCode() {
        return this.getRawType().hashCode();
    }

    public String toString() {
        return TypeUsageImpl.toString(this, new HashSet<TypeUsage>());
    }

    private static String toString(TypeUsage self, Set<TypeUsage> touchedTypes) {
        if (self instanceof TypeUsageImpl) {
            return ((TypeUsageImpl)self).toString(touchedTypes);
        }
        return self.toString();
    }

    private String toString(Set<TypeUsage> touchedTypes) {
        if (touchedTypes.contains(this)) {
            if (this.isTypeVariableOrWildcard()) {
                return this.typeVariable;
            }
            return "";
        }
        touchedTypes.add(this);
        String representation = this.getRawType().getSimpleName();
        if (this.isGeneric()) {
            String typeArgsRepresentation = this.typeArguments.stream().map(typeUsage -> TypeUsageImpl.toString(typeUsage, touchedTypes)).collect(Collectors.joining(", "));
            representation = String.format("%s<%s>", representation, typeArgsRepresentation);
        }
        if (this.isArray()) {
            representation = String.format("%s[]", TypeUsageImpl.toString(this.getComponentType().get(), touchedTypes));
        }
        if (this.typeVariable != null) {
            String boundsRepresentation;
            representation = this.typeVariable;
            if (this.hasUpperBoundBeyondObject()) {
                boundsRepresentation = this.upperBounds.stream().map(typeUsage -> TypeUsageImpl.toString(typeUsage, touchedTypes)).collect(Collectors.joining(" & "));
                representation = representation + String.format(" extends %s", boundsRepresentation);
            }
            if (this.hasLowerBounds()) {
                boundsRepresentation = this.lowerBounds.stream().map(typeUsage -> TypeUsageImpl.toString(typeUsage, touchedTypes)).collect(Collectors.joining(" & "));
                representation = representation + String.format(" super %s", boundsRepresentation);
            }
        }
        if (!this.annotations.isEmpty()) {
            String annotationRepresentation = this.annotations.stream().map(Annotation::toString).collect(Collectors.joining(" "));
            representation = annotationRepresentation + " " + representation;
        }
        return representation;
    }
}

