/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.ArrayList;
import java.util.Map;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.reporting.ReportEntry;

class ReportEntrySupport {
    ReportEntrySupport() {
    }

    public static void printToStdout(TestDescriptor testDescriptor, ReportEntry entry) {
        String formattedEntry = ReportEntrySupport.isCheckResultEntry(entry) ? ReportEntrySupport.formatCheckResultReportEntry(entry) : ReportEntrySupport.formatStandardEntry(entry);
        System.out.println(formattedEntry);
    }

    private static String formatStandardEntry(ReportEntry entry) {
        ArrayList<String> stringEntries = new ArrayList<String>();
        stringEntries.add(String.format("timestamp = %s", entry.getTimestamp()));
        for (Map.Entry keyValue : entry.getKeyValuePairs().entrySet()) {
            stringEntries.add(String.format("%s = %s", keyValue.getKey(), keyValue.getValue()));
        }
        return String.join((CharSequence)", ", stringEntries) + String.format("%n", new Object[0]);
    }

    private static boolean isCheckResultEntry(ReportEntry entry) {
        return entry.getKeyValuePairs().containsKey("tries");
    }

    private static String formatCheckResultReportEntry(ReportEntry entry) {
        ArrayList<String> stringEntries = new ArrayList<String>();
        stringEntries.add(String.format("timestamp = %s%n", entry.getTimestamp()));
        ArrayList<String> sortedKeys = ReportEntrySupport.sortKeys(entry);
        for (String key : sortedKeys) {
            String value = (String)entry.getKeyValuePairs().get(key);
            stringEntries.add(String.format("    %s = %s%n", key, value));
        }
        return String.join((CharSequence)"", stringEntries);
    }

    private static ArrayList<String> sortKeys(ReportEntry entry) {
        ArrayList<String> keys = new ArrayList<String>(entry.getKeyValuePairs().keySet());
        ReportEntrySupport.sortToStart(keys, "sample", "original-sample", "seed", "after-failure", "generation-mode", "checks", "tries");
        return keys;
    }

    private static void sortToStart(ArrayList<String> keys, String ... keysToStartWith) {
        for (String firstKey : keysToStartWith) {
            if (!keys.remove(firstKey)) continue;
            keys.add(0, firstKey);
        }
    }
}

