/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.Arrays;
import net.jqwik.api.ForAll;
import net.jqwik.api.JqwikException;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.lifecycle.SkipExecutionHook;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.PropertyExecutionListener;
import net.jqwik.engine.execution.PropertyMethodExecutor;
import net.jqwik.engine.execution.PropertyMethodLifecycleContext;
import net.jqwik.engine.execution.lifecycle.LifecycleSupplier;
import net.jqwik.engine.execution.pipeline.ExecutionTask;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.engine.TestDescriptor;

class PropertyTaskCreator {
    PropertyTaskCreator() {
    }

    ExecutionTask createTask(PropertyMethodDescriptor methodDescriptor, LifecycleSupplier lifecycleSupplier) {
        if (this.hasUnspecifiedParameters(methodDescriptor)) {
            String taskDescription = "skipping " + methodDescriptor.getDisplayName();
            return ExecutionTask.from(listener -> listener.executionSkipped((TestDescriptor)methodDescriptor, "Cannot run methods with unbound parameters - yet."), methodDescriptor.getUniqueId(), taskDescription);
        }
        return ExecutionTask.from(listener -> {
            Object testInstance = this.createTestInstance(methodDescriptor);
            PropertyMethodLifecycleContext propertyLifecycleContext = new PropertyMethodLifecycleContext(methodDescriptor, testInstance);
            SkipExecutionHook skipExecutionHook = lifecycleSupplier.skipExecutionHook((TestDescriptor)methodDescriptor);
            SkipExecutionHook.SkipResult skipResult = skipExecutionHook.shouldBeSkipped((LifecycleContext)propertyLifecycleContext);
            if (skipResult.isSkipped()) {
                listener.executionSkipped((TestDescriptor)methodDescriptor, skipResult.reason().orElse(null));
                return;
            }
            listener.executionStarted((TestDescriptor)methodDescriptor);
            PropertyExecutionResult executionResult = this.executeTestMethod(methodDescriptor, propertyLifecycleContext, lifecycleSupplier, (PropertyExecutionListener)listener);
            listener.executionFinished((TestDescriptor)methodDescriptor, executionResult);
        }, methodDescriptor.getUniqueId(), "executing " + methodDescriptor.getDisplayName());
    }

    private Object createTestInstance(PropertyMethodDescriptor methodDescriptor) {
        try {
            return JqwikReflectionSupport.newInstanceWithDefaultConstructor(methodDescriptor.getContainerClass());
        }
        catch (Throwable throwable) {
            String message = String.format("Cannot create instance of class '%s'. Maybe it has no default constructor?", methodDescriptor.getContainerClass());
            throw new JqwikException(message, throwable);
        }
    }

    private boolean hasUnspecifiedParameters(PropertyMethodDescriptor methodDescriptor) {
        return Arrays.stream(methodDescriptor.getTargetMethod().getParameters()).anyMatch(parameter -> !parameter.isAnnotationPresent(ForAll.class));
    }

    private PropertyExecutionResult executeTestMethod(PropertyMethodDescriptor methodDescriptor, PropertyLifecycleContext propertyLifecycleContext, LifecycleSupplier lifecycleSupplier, PropertyExecutionListener listener) {
        PropertyMethodExecutor executor = new PropertyMethodExecutor(methodDescriptor, propertyLifecycleContext);
        return executor.execute(lifecycleSupplier, listener);
    }
}

