/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.CheckedProperty;
import net.jqwik.engine.execution.CheckedPropertyFactory;
import net.jqwik.engine.execution.PropertyExecutionListener;
import net.jqwik.engine.execution.lifecycle.LifecycleSupplier;
import net.jqwik.engine.properties.PropertyCheckResult;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.reporting.ReportEntry;
import org.opentest4j.TestAbortedException;

public class PropertyMethodExecutor {
    private static final Logger LOG = Logger.getLogger(PropertyMethodExecutor.class.getName());
    private final PropertyMethodDescriptor methodDescriptor;
    private final PropertyLifecycleContext propertyLifecycleContext;
    private CheckedPropertyFactory checkedPropertyFactory = new CheckedPropertyFactory();

    public PropertyMethodExecutor(PropertyMethodDescriptor methodDescriptor, PropertyLifecycleContext propertyLifecycleContext) {
        this.methodDescriptor = methodDescriptor;
        this.propertyLifecycleContext = propertyLifecycleContext;
    }

    public PropertyExecutionResult execute(LifecycleSupplier lifecycleSupplier, PropertyExecutionListener listener) {
        return this.executePropertyMethod(lifecycleSupplier, listener);
    }

    private PropertyExecutionResult executePropertyMethod(LifecycleSupplier lifecycleSupplier, PropertyExecutionListener listener) {
        PropertyExecutionResult propertyExecutionResult = PropertyExecutionResult.successful((String)this.methodDescriptor.getConfiguration().getSeed());
        AroundPropertyHook around = lifecycleSupplier.aroundPropertyHook(this.methodDescriptor);
        try {
            propertyExecutionResult = around.aroundProperty(this.propertyLifecycleContext, () -> this.executeMethod(this.propertyLifecycleContext.testInstance(), listener));
        }
        catch (Throwable throwable) {
            if (propertyExecutionResult.getStatus() == PropertyExecutionResult.Status.SUCCESSFUL) {
                return PropertyExecutionResult.failed((Throwable)throwable, (String)propertyExecutionResult.getSeed().orElse(null), (List)propertyExecutionResult.getFalsifiedSample().orElse(null));
            }
            LOG.warning(throwable.toString());
            return propertyExecutionResult;
        }
        return propertyExecutionResult;
    }

    private PropertyExecutionResult executeMethod(Object testInstance, PropertyExecutionListener listener) {
        try {
            Consumer<ReportEntry> reporter = entry -> listener.reportingEntryPublished((TestDescriptor)this.methodDescriptor, (ReportEntry)entry);
            PropertyCheckResult checkResult = this.executeProperty(testInstance, reporter);
            return checkResult.toExecutionResult();
        }
        catch (TestAbortedException e) {
            return PropertyExecutionResult.aborted((Throwable)e, (String)this.methodDescriptor.getConfiguration().getSeed());
        }
        catch (Throwable t) {
            BlacklistedExceptions.rethrowIfBlacklisted((Throwable)t);
            return PropertyExecutionResult.failed((Throwable)t, (String)this.methodDescriptor.getConfiguration().getSeed(), null);
        }
    }

    private PropertyCheckResult executeProperty(Object testInstance, Consumer<ReportEntry> publisher) {
        CheckedProperty property = this.checkedPropertyFactory.fromDescriptor(this.methodDescriptor, testInstance);
        return property.check(publisher, this.methodDescriptor.getReporting());
    }
}

