/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.discovery.specs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.engine.discovery.predicates.IsProperty;
import net.jqwik.engine.discovery.specs.DiscoverySpec;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.JqwikStringSupport;
import org.junit.platform.engine.support.hierarchical.Node;

public class PropertyDiscoverySpec
implements DiscoverySpec<Method> {
    private final IsProperty isProperty = new IsProperty();

    @Override
    public boolean shouldBeDiscovered(Method candidate) {
        return this.isProperty.test(candidate);
    }

    @Override
    public Node.SkipResult shouldBeSkipped(Method candidate) {
        if (JqwikReflectionSupport.isStatic(candidate)) {
            return Node.SkipResult.skip((String)"A @Property method must not be static");
        }
        if (this.hasJupiterAnnotation(candidate)) {
            return Node.SkipResult.skip((String)String.format("A @Property method must not have Jupiter annotations: %s", JqwikStringSupport.displayString(this.findJupiterAnnotations(candidate))));
        }
        return Node.SkipResult.doNotSkip();
    }

    private boolean hasJupiterAnnotation(Method candidate) {
        return this.findJupiterAnnotations(candidate).size() > 0;
    }

    private List<Annotation> findJupiterAnnotations(Method candidate) {
        return Arrays.stream(candidate.getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().getPackage().getName().startsWith("org.junit.jupiter")).collect(Collectors.toList());
    }
}

