/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.discovery;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import net.jqwik.engine.discovery.ElementResolver;
import net.jqwik.engine.discovery.predicates.IsContainerAGroup;
import net.jqwik.engine.discovery.predicates.IsDiscoverableTestMethod;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

class HierarchicalJavaResolver {
    private static final Logger LOG = Logger.getLogger(HierarchicalJavaResolver.class.getName());
    private static final IsContainerAGroup isContainerAGroup = new IsContainerAGroup();
    private static final IsDiscoverableTestMethod isDiscoverableTestMethod = new IsDiscoverableTestMethod();
    private final TestDescriptor engineDescriptor;
    private final Set<ElementResolver> resolvers;

    HierarchicalJavaResolver(TestDescriptor engineDescriptor, Set<ElementResolver> resolvers) {
        this.engineDescriptor = engineDescriptor;
        this.resolvers = resolvers;
    }

    void resolveClass(Class<?> testClass) {
        Set<TestDescriptor> resolvedDescriptors = this.resolveContainerWithParents(testClass);
        resolvedDescriptors.forEach(this::resolveChildren);
        if (resolvedDescriptors.isEmpty()) {
            LOG.info(() -> String.format("Received request to resolve class '%s' as test container but could not fulfill it", testClass.getName()));
        }
    }

    void resolveMethod(Class<?> testClass, Method testMethod) {
        Set<TestDescriptor> potentialParents = this.resolveContainerWithParents(testClass);
        Set<TestDescriptor> resolvedDescriptors = this.resolveForAllParents(testMethod, potentialParents);
        if (resolvedDescriptors.isEmpty()) {
            LOG.info(() -> String.format("Received request to resolve method '%s' as test but could not fulfill it", testMethod.toGenericString()));
        }
    }

    private Set<TestDescriptor> resolveContainerWithParents(Class<?> testClass) {
        Set<TestDescriptor> potentialParents = isContainerAGroup.test(testClass) ? this.resolveContainerWithParents(testClass.getDeclaringClass()) : Collections.singleton(this.engineDescriptor);
        return this.resolveForAllParents(testClass, potentialParents);
    }

    void resolveUniqueId(UniqueId uniqueId) {
        ArrayList<UniqueId.Segment> segments = new ArrayList<UniqueId.Segment>(uniqueId.getSegments());
        segments.remove(0);
        if (!this.resolveUniqueId(this.engineDescriptor, segments)) {
            LOG.warning(() -> String.format("Received request to resolve unique id '%s' as test or test container but could not fulfill it", uniqueId));
        }
    }

    private boolean resolveUniqueId(TestDescriptor parent, List<UniqueId.Segment> remainingSegments) {
        if (remainingSegments.isEmpty()) {
            this.resolveChildren(parent);
            return true;
        }
        UniqueId.Segment head = remainingSegments.remove(0);
        for (ElementResolver resolver : this.resolvers) {
            Optional<TestDescriptor> resolvedDescriptor = resolver.resolveUniqueId(head, parent);
            if (!resolvedDescriptor.isPresent()) continue;
            Optional<TestDescriptor> foundTestDescriptor = this.findTestDescriptorByUniqueId(resolvedDescriptor.get().getUniqueId());
            TestDescriptor descriptor = foundTestDescriptor.orElseGet(() -> {
                TestDescriptor newDescriptor = (TestDescriptor)resolvedDescriptor.get();
                parent.addChild(newDescriptor);
                return newDescriptor;
            });
            return this.resolveUniqueId(descriptor, remainingSegments);
        }
        return false;
    }

    private Set<TestDescriptor> resolveContainerWithChildren(Class<?> containerClass, Set<TestDescriptor> potentialParents) {
        Set<TestDescriptor> resolvedDescriptors = this.resolveForAllParents(containerClass, potentialParents);
        resolvedDescriptors.forEach(this::resolveChildren);
        return resolvedDescriptors;
    }

    private Set<TestDescriptor> resolveForAllParents(AnnotatedElement element, Set<TestDescriptor> potentialParents) {
        HashSet<TestDescriptor> resolvedDescriptors = new HashSet<TestDescriptor>();
        potentialParents.forEach(parent -> resolvedDescriptors.addAll(this.resolve(element, (TestDescriptor)parent)));
        return resolvedDescriptors;
    }

    private void resolveChildren(TestDescriptor descriptor) {
        if (descriptor instanceof ContainerClassDescriptor) {
            ContainerClassDescriptor containerClassDescriptor = (ContainerClassDescriptor)descriptor;
            Class<?> containerClass = containerClassDescriptor.getContainerClass();
            this.resolveContainedMethods(descriptor, containerClass);
            this.resolveContainedGroups(containerClassDescriptor, containerClass);
        }
    }

    private void resolveContainedGroups(ContainerClassDescriptor containerClassDescriptor, Class<?> containerClass) {
        IsContainerAGroup isGroup = new IsContainerAGroup();
        List containedContainersCandidates = ReflectionSupport.findNestedClasses(containerClass, (Predicate)isGroup);
        containedContainersCandidates.forEach(nestedClass -> this.resolveContainerWithChildren((Class<?>)nestedClass, (Set<TestDescriptor>)Collections.singleton(containerClassDescriptor)));
    }

    private void resolveContainedMethods(TestDescriptor containerDescriptor, Class<?> testClass) {
        List testMethodCandidates = ReflectionSupport.findMethods(testClass, (Predicate)isDiscoverableTestMethod, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        testMethodCandidates.forEach(method -> this.resolve((AnnotatedElement)method, containerDescriptor));
    }

    private Set<TestDescriptor> resolve(AnnotatedElement element, TestDescriptor parent) {
        return this.resolvers.stream().map(resolver -> this.tryToResolveWithResolver(element, parent, (ElementResolver)resolver)).filter(testDescriptors -> !testDescriptors.isEmpty()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<TestDescriptor> tryToResolveWithResolver(AnnotatedElement element, TestDescriptor parent, ElementResolver resolver) {
        Set<TestDescriptor> resolvedDescriptors = resolver.resolveElement(element, parent);
        LinkedHashSet<TestDescriptor> result = new LinkedHashSet<TestDescriptor>();
        resolvedDescriptors.forEach(testDescriptor -> {
            Optional<TestDescriptor> existingTestDescriptor = this.findTestDescriptorByUniqueId(testDescriptor.getUniqueId());
            if (existingTestDescriptor.isPresent()) {
                result.add(existingTestDescriptor.get());
            } else {
                parent.addChild(testDescriptor);
                result.add((TestDescriptor)testDescriptor);
            }
        });
        return result;
    }

    private Optional<TestDescriptor> findTestDescriptorByUniqueId(UniqueId uniqueId) {
        return this.engineDescriptor.findByUniqueId(uniqueId);
    }
}

