/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Label;
import net.jqwik.api.Tag;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.engine.TestTag;

public class DiscoverySupport {
    private static final Logger LOG = Logger.getLogger(DiscoverySupport.class.getName());

    public static Set<TestTag> findTestTags(AnnotatedElement element) {
        return AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)element, Tag.class).stream().map(Tag::value).filter(tag -> {
            if (!TestTag.isValid((String)tag)) {
                String message = String.format("Invalid tag format in @Tag(\"%s\") on [%s].", tag, element);
                throw new JqwikException(message);
            }
            return true;
        }).map(TestTag::create).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    public static String determineLabel(AnnotatedElement element, Supplier<String> defaultNameSupplier) {
        return AnnotationSupport.findAnnotation((AnnotatedElement)element, Label.class).map(Label::value).filter(displayName -> !displayName.trim().isEmpty()).orElseGet(DiscoverySupport.readableNameSupplier(defaultNameSupplier));
    }

    private static Supplier<String> readableNameSupplier(Supplier<String> nameSupplier) {
        return () -> ((String)nameSupplier.get()).replaceAll("_", " ");
    }

    public static void warnWhenJunitAnnotationsArePresent(AnnotatedElement element) {
        Annotation[] directAnnotations;
        for (Annotation annotation : directAnnotations = element.getDeclaredAnnotations()) {
            if (!annotation.annotationType().getPackage().getName().startsWith("org.junit")) continue;
            String message = String.format("[%s] has annotation [%s] from JUnit which cannot be processed by jqwik", element, annotation);
            LOG.warning(message);
        }
    }
}

