/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.jqwik.api.Report;
import net.jqwik.api.Reporting;
import net.jqwik.engine.descriptor.DiscoverySupport;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.MethodSource;

abstract class AbstractMethodDescriptor
extends AbstractTestDescriptor {
    private final Method targetMethod;
    private final Class containerClass;
    private final Set<TestTag> tags;

    AbstractMethodDescriptor(UniqueId uniqueId, Method targetMethod, Class containerClass) {
        super(uniqueId, AbstractMethodDescriptor.determineDisplayName(targetMethod), (TestSource)MethodSource.from((Method)targetMethod));
        this.warnWhenJunitAnnotationsArePresent(targetMethod);
        this.tags = this.determineTags(targetMethod);
        this.containerClass = containerClass;
        this.targetMethod = targetMethod;
    }

    private void warnWhenJunitAnnotationsArePresent(Method targetMethod) {
        DiscoverySupport.warnWhenJunitAnnotationsArePresent(targetMethod);
    }

    private Set<TestTag> determineTags(Method targetMethod) {
        return DiscoverySupport.findTestTags(targetMethod);
    }

    private static String determineDisplayName(Method targetMethod) {
        return DiscoverySupport.determineLabel(targetMethod, targetMethod::getName);
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public Class<?> getContainerClass() {
        return this.containerClass;
    }

    public String getLabel() {
        return this.getDisplayName();
    }

    public Set<TestTag> getTags() {
        LinkedHashSet<TestTag> allTags = new LinkedHashSet<TestTag>(this.tags);
        this.getParent().ifPresent(parentDescriptor -> allTags.addAll(parentDescriptor.getTags()));
        return allTags;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public Reporting[] getReporting() {
        Optional optionalReport = AnnotationSupport.findAnnotation((AnnotatedElement)this.getTargetMethod(), Report.class);
        return optionalReport.map(Report::value).orElse(new Reporting[0]);
    }
}

