/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.configurators;

import net.jqwik.api.JqwikException;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.constraints.StringLength;

public class StringLengthConfigurator
extends ArbitraryConfiguratorBase {
    public StringArbitrary configure(StringArbitrary arbitrary, StringLength stringLength) {
        this.checkSize(stringLength);
        if (stringLength.value() != 0) {
            return arbitrary.ofLength(stringLength.value());
        }
        StringArbitrary newArbitrary = arbitrary;
        if (stringLength.min() != 0) {
            newArbitrary = newArbitrary.ofMinLength(stringLength.min());
        }
        if (stringLength.max() != 0) {
            newArbitrary = newArbitrary.ofMaxLength(stringLength.max());
        }
        return newArbitrary;
    }

    private void checkSize(StringLength stringLength) {
        if (stringLength.value() == 0) {
            if (stringLength.min() > stringLength.max() && stringLength.max() != 0) {
                this.reportError(stringLength);
            }
        } else if (stringLength.min() != 0 || stringLength.max() != 0) {
            this.reportError(stringLength);
        }
    }

    private void reportError(StringLength stringLength) {
        throw new JqwikException(String.format("%s: You have to either choose a fixed value or set min/max", stringLength));
    }
}

