/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.configurators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import net.jqwik.api.configurators.ArbitraryConfigurator;

public class RegisteredArbitraryConfigurators {
    private static List<ArbitraryConfigurator> registeredConfigurators;

    public static List<ArbitraryConfigurator> getConfigurators() {
        if (null == registeredConfigurators) {
            RegisteredArbitraryConfigurators.loadArbitraryConfigurators();
        }
        return Collections.unmodifiableList(registeredConfigurators);
    }

    private static void loadArbitraryConfigurators() {
        registeredConfigurators = new ArrayList<ArbitraryConfigurator>();
        ServiceLoader<ArbitraryConfigurator> providers = ServiceLoader.load(ArbitraryConfigurator.class);
        for (ArbitraryConfigurator provider : providers) {
            RegisteredArbitraryConfigurators.register(provider);
        }
        Collections.sort(registeredConfigurators);
    }

    public static void register(ArbitraryConfigurator configurator) {
        if (RegisteredArbitraryConfigurators.getConfigurators().contains(configurator)) {
            return;
        }
        registeredConfigurators.add(0, configurator);
    }
}

