/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.configurators;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.BigDecimalArbitrary;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;
import net.jqwik.api.arbitraries.ByteArbitrary;
import net.jqwik.api.arbitraries.DoubleArbitrary;
import net.jqwik.api.arbitraries.FloatArbitrary;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.api.arbitraries.ShortArbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.constraints.Negative;

public class NegativeConfigurator
extends ArbitraryConfiguratorBase {
    public Arbitrary<BigDecimal> configure(BigDecimalArbitrary arbitrary, Negative negative) {
        return arbitrary.lessOrEqual(BigDecimal.valueOf(-1L)).filter(value -> value.compareTo(BigDecimal.ZERO) < 0);
    }

    public BigIntegerArbitrary configure(BigIntegerArbitrary arbitrary, Negative negative) {
        return arbitrary.lessOrEqual(BigInteger.valueOf(-1L));
    }

    public ByteArbitrary configure(ByteArbitrary arbitrary, Negative negative) {
        return arbitrary.lessOrEqual((byte)-1);
    }

    public Arbitrary<Double> configure(DoubleArbitrary arbitrary, Negative negative) {
        return arbitrary.lessOrEqual(0.0).filter(value -> value < 0.0);
    }

    public Arbitrary<Float> configure(FloatArbitrary arbitrary, Negative negative) {
        return arbitrary.lessOrEqual(-0.0f).filter(value -> value.floatValue() < 0.0f);
    }

    public IntegerArbitrary configure(IntegerArbitrary arbitrary, Negative negative) {
        return arbitrary.lessOrEqual(-1);
    }

    public LongArbitrary configure(LongArbitrary arbitrary, Negative negative) {
        return arbitrary.lessOrEqual(-1L);
    }

    public ShortArbitrary configure(ShortArbitrary arbitrary, Negative negative) {
        return arbitrary.lessOrEqual((short)-1);
    }
}

