/*
 * Decompiled with CFR 0.152.
 */
package net.jp.saf.sastruts.method.impl;

import java.util.EnumSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jp.saf.sastruts.method.CheckResult;
import net.jp.saf.sastruts.method.HttpMethodChecker;
import net.jp.saf.sastruts.method.enums.ExtensionHeaderBehavior;
import net.jp.saf.sastruts.method.enums.HttpMethod;
import net.jp.saf.sastruts.method.helpers.ErrorHandler;
import net.jp.saf.sastruts.method.helpers.impl.MethodNotAllowedErrorHandler;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMethodCheckerImpl
implements HttpMethodChecker {
    private static final long serialVersionUID = 1L;
    protected String extensionHeaderName = "X-Http-Method-Override";
    protected ExtensionHeaderBehavior defaultExtHeaderBehavior = ExtensionHeaderBehavior.NOT_USE;
    protected HttpMethod[] defaultAllows = new HttpMethod[0];
    protected HttpMethod[] defaultAnnotationAllows = new HttpMethod[]{HttpMethod.GET_POST};
    protected ErrorHandler errorHandler = new MethodNotAllowedErrorHandler();

    @Binding(bindingType=BindingType.MAY)
    public void setExtensionHeaderName(String extensionHeaderName) {
        this.extensionHeaderName = extensionHeaderName;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setExtensionHeader(ExtensionHeaderBehavior extensionHeader) {
        this.defaultExtHeaderBehavior = extensionHeader;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setDefaultAllows(List<HttpMethod> defaultAllows) {
        this.defaultAllows = defaultAllows == null || defaultAllows.isEmpty() ? new HttpMethod[0] : EnumSet.copyOf(defaultAllows).toArray(new HttpMethod[0]);
    }

    @Binding(bindingType=BindingType.MAY)
    public void setDefaultAnnotationAllows(List<HttpMethod> defaultAnnotationAllows) {
        this.defaultAnnotationAllows = defaultAnnotationAllows == null || defaultAnnotationAllows.isEmpty() ? new HttpMethod[0] : EnumSet.copyOf(defaultAnnotationAllows).toArray(new HttpMethod[0]);
    }

    @Binding(bindingType=BindingType.MAY)
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public CheckResult check(HttpServletRequest request, HttpMethod[] allows, ExtensionHeaderBehavior extensionHeaderBehavior) {
        HttpMethod[] checkAllows = null;
        if (allows != null) {
            checkAllows = allows;
            if (allows.length == 0) {
                checkAllows = this.defaultAnnotationAllows;
            }
        } else {
            checkAllows = this.defaultAllows;
        }
        String httpMethod = this.detectCurrentHttpMethod(request, extensionHeaderBehavior);
        boolean ok = true;
        if (checkAllows.length > 0) {
            ok = false;
            for (HttpMethod allow : checkAllows) {
                if (!allow.check(httpMethod)) continue;
                ok = true;
                break;
            }
        }
        return ok ? CheckResult.ok(httpMethod, checkAllows) : CheckResult.ng(httpMethod, checkAllows);
    }

    @Override
    public String handleError(HttpServletRequest request, HttpServletResponse response, HttpMethod[] allowed, String method) {
        return this.errorHandler.error(request, response, allowed, method);
    }

    protected String detectCurrentHttpMethod(HttpServletRequest request, ExtensionHeaderBehavior customBehavior) {
        ExtensionHeaderBehavior behavior = this.defaultExtHeaderBehavior;
        if (customBehavior != null && customBehavior != ExtensionHeaderBehavior.NOT_DEFINE) {
            behavior = customBehavior;
        }
        if (behavior == ExtensionHeaderBehavior.NOT_USE || behavior == ExtensionHeaderBehavior.NOT_DEFINE) {
            return request.getMethod();
        }
        if (behavior == ExtensionHeaderBehavior.HEADER_ONLY) {
            return request.getHeader(this.extensionHeaderName);
        }
        String method = null;
        if (behavior == ExtensionHeaderBehavior.HEADER_FIRST) {
            method = request.getHeader(this.extensionHeaderName);
        }
        if (StringUtil.isEmpty(method)) {
            return request.getMethod();
        }
        return method;
    }
}

