/*
 * Decompiled with CFR 0.152.
 */
package net.jp.saf.sastruts.method.helpers.impl;

import java.util.TreeSet;
import net.jp.saf.sastruts.method.enums.HttpMethod;
import net.jp.saf.sastruts.method.exception.MethodNotAllowedRuntimeException;
import net.jp.saf.sastruts.method.helpers.ErrorHandler;
import org.seasar.struts.taglib.S2Functions;

public abstract class AbstractErrorHandler
implements ErrorHandler {
    private static final long serialVersionUID = 5454469329362034342L;

    protected String allowHeaderValue(HttpMethod[] methods) {
        if (methods == null || methods.length == 0) {
            return "";
        }
        TreeSet<String> allows = new TreeSet<String>();
        for (HttpMethod method : methods) {
            if (method == HttpMethod.GET_POST) {
                allows.add(HttpMethod.GET.name());
                allows.add(HttpMethod.POST.name());
                continue;
            }
            if (method == HttpMethod.REST_CRUD) {
                allows.add(HttpMethod.DELETE.name());
                allows.add(HttpMethod.GET.name());
                allows.add(HttpMethod.POST.name());
                allows.add(HttpMethod.PUT.name());
                continue;
            }
            if (method == HttpMethod.ALL) {
                allows.add(HttpMethod.DELETE.name());
                allows.add(HttpMethod.GET.name());
                allows.add(HttpMethod.POST.name());
                allows.add(HttpMethod.PUT.name());
                allows.add(HttpMethod.HEAD.name());
                allows.add(HttpMethod.OPTIONS.name());
                allows.add(HttpMethod.TRACE.name());
                break;
            }
            allows.add(method.name());
        }
        if (allows.size() == 1) {
            return (String)allows.first();
        }
        StringBuilder buff = new StringBuilder();
        for (String allow : allows) {
            buff.append(',').append(allow);
        }
        return buff.substring(1);
    }

    protected final void throwMethodNotAllowedRuntimeException(HttpMethod[] allowed, String method, Throwable cause) {
        String httpMethod = method == null ? "" : S2Functions.escape((String)method);
        String allowedMethods = this.allowHeaderValue(allowed);
        if (cause == null) {
            throw new MethodNotAllowedRuntimeException(httpMethod, allowedMethods);
        }
        throw new MethodNotAllowedRuntimeException(httpMethod, allowedMethods, cause);
    }
}

