/*
 * Decompiled with CFR 0.152.
 */
package net.jp.saf.http.cookie.syntax.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.Cookie;
import net.jp.saf.http.cookie.impl.CookieImpl;
import net.jp.saf.http.cookie.syntax.CookieAttribute;
import net.jp.saf.http.cookie.syntax.CookieFormatter;
import net.jp.saf.http.cookie.syntax.impl.AbstractCookieAttributeImpl;

public class HttpOnlyAttribute
extends AbstractCookieAttributeImpl {
    public HttpOnlyAttribute(CookieAttribute nextAttr) {
        super(nextAttr);
    }

    protected String writeAttribute(Cookie seed, CookieFormatter formatter) {
        if (seed instanceof CookieImpl) {
            return ((CookieImpl)seed).isHttpOnly() ? "; HttpOnly" : "";
        }
        if (!CookieImpl.isHttpOnlySupported()) {
            return "";
        }
        try {
            Method isHttpOnly = Cookie.class.getMethod("isHttpOnly", new Class[0]);
            Object httpOnly = isHttpOnly.invoke((Object)seed, new Object[0]);
            if (httpOnly instanceof Boolean) {
                return (Boolean)httpOnly != false ? "; HttpOnly" : "";
            }
        }
        catch (SecurityException e) {
            return "";
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        catch (NoSuchMethodException e) {
            return "";
        }
        catch (IllegalAccessException e) {
            return "";
        }
        catch (InvocationTargetException e) {
            return "";
        }
        return "";
    }
}

