/*
 * Decompiled with CFR 0.152.
 */
package net.jp.saf.http.cookie.syntax.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import net.jp.saf.http.cookie.syntax.CookieAttribute;
import net.jp.saf.http.cookie.syntax.CookieFormatter;
import net.jp.saf.http.cookie.syntax.impl.AbstractCookieAttributeImpl;

public class ExpiresAttribute
extends AbstractCookieAttributeImpl {
    protected final ThreadLocal<DateFormat> expiresFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };
    protected static final String OLD_EXPIRES = "Thu, 01-Jan-1970 00:00:00 GMT";
    protected final boolean needMaxAgeAttr;
    private Date baseDate = null;

    public ExpiresAttribute(CookieAttribute nextAttr) {
        this(nextAttr, false);
    }

    public ExpiresAttribute(CookieAttribute nextAttr, boolean isNeedMaxAgeAttr) {
        super(nextAttr);
        this.needMaxAgeAttr = isNeedMaxAgeAttr;
    }

    public void setBaseDate(Date date) {
        this.baseDate = date;
    }

    protected String writeAttribute(Cookie seed, CookieFormatter formatter) {
        int maxAge = seed.getMaxAge();
        if (maxAge > -1) {
            String expires = "; Expires=" + this.createExpiresValue(maxAge);
            if (this.needMaxAgeAttr) {
                return expires + "; Max-Age=" + maxAge;
            }
            return expires;
        }
        return "";
    }

    protected String createExpiresValue(int maxAge) {
        if (maxAge == 0) {
            return OLD_EXPIRES;
        }
        long currentTime = this.baseDate == null ? System.currentTimeMillis() : this.baseDate.getTime();
        return this.expiresFormat.get().format(new Date(currentTime + (long)maxAge * 1000L));
    }
}

