/*
 * Decompiled with CFR 0.152.
 */
package net.jp.saf.http.cookie.syntax.impl;

import net.jp.saf.http.cookie.syntax.CookieFormatter;
import net.jp.saf.http.cookie.syntax.enums.TokenSeparators;

public class CookieFormatterImpl
implements CookieFormatter {
    protected final TokenSeparators separator;
    protected static final char SPACE = ' ';
    protected static final char DEL = '\u007f';

    public CookieFormatterImpl() {
        this(TokenSeparators.RFC2616);
    }

    public CookieFormatterImpl(TokenSeparators tokenSeparators) {
        this.separator = tokenSeparators;
    }

    public TokenSeparators getCurrentTokenSeparator() {
        return this.separator;
    }

    public String format(String sourceText) {
        return this.format(sourceText, this.separator);
    }

    public String format(String sourceText, TokenSeparators separators) {
        int len;
        if (sourceText == null || sourceText.length() == 0) {
            return "";
        }
        boolean quoted = sourceText.charAt(0) == '\"' && sourceText.charAt(sourceText.length() - 1) == '\"';
        boolean needQuote = false;
        StringBuffer buf = new StringBuffer(sourceText.length() + 4);
        int n = len = quoted ? sourceText.length() - 1 : sourceText.length();
        for (int i = quoted ? 1 : 0; i < len; ++i) {
            char checkChar = sourceText.charAt(i);
            if (this.isCTLs(checkChar, separators)) {
                throw new IllegalArgumentException("Control character in cookie value, consider BASE64 encoding your value");
            }
            if (separators.contains(checkChar)) {
                needQuote = true;
                if (checkChar == '\"') {
                    buf.append("\\\"");
                    continue;
                }
                if (checkChar == '\\') {
                    if (++i >= len) {
                        throw new IllegalArgumentException("Invalid escape character in cookie value.");
                    }
                    buf.append(checkChar);
                    char nextChar = sourceText.charAt(i);
                    if (this.isCTLs(nextChar, separators)) {
                        buf.append(' ');
                        continue;
                    }
                    buf.append(nextChar);
                    continue;
                }
                buf.append(checkChar);
                continue;
            }
            buf.append(checkChar);
        }
        if (quoted || needQuote) {
            buf.append('\"');
            return '\"' + buf.toString();
        }
        return buf.toString();
    }

    protected boolean isCTLs(char chr, TokenSeparators allowedSeparator) {
        if (chr < ' ' || chr >= '\u007f') {
            return !allowedSeparator.contains(chr);
        }
        return false;
    }
}

