/*
 * Decompiled with CFR 0.152.
 */
package net.jp.saf.http.cookie.impl;

import javax.servlet.http.Cookie;
import net.jp.saf.http.cookie.factory.InstanceFactory;
import net.jp.saf.http.cookie.factory.impl.InstanceFactoryImpl;

public class CookieImpl
extends Cookie {
    private static final InstanceFactory TO_STRING = new InstanceFactoryImpl();
    private static final boolean COOKIE_HTTPONLY_SUPPORT;
    private boolean httpOnly;

    public CookieImpl(String name, String value) {
        super(name, value);
    }

    public static boolean isHttpOnlySupported() {
        return COOKIE_HTTPONLY_SUPPORT;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean isHttpOnly) {
        this.httpOnly = isHttpOnly;
    }

    public Object clone() {
        CookieImpl clone = (CookieImpl)((Object)super.clone());
        clone.setHttpOnly(this.httpOnly);
        return clone;
    }

    public String toString() {
        return TO_STRING.buildCookieAttribute(this.getVersion()).write(this, TO_STRING.createCookieFormatter(this.getVersion()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean hasMethod = true;
        try {
            Cookie.class.getMethod("setHttpOnly", Boolean.TYPE);
        }
        catch (Exception e) {
            hasMethod = false;
        }
        finally {
            COOKIE_HTTPONLY_SUPPORT = hasMethod;
        }
    }
}

