/*
 * Decompiled with CFR 0.152.
 */
package net.jp.saf.http.cookie.impl;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.jp.saf.http.cookie.CookieBuilder;
import net.jp.saf.http.cookie.factory.InstanceFactory;
import net.jp.saf.http.cookie.impl.CookieImpl;

public class CookieBuilderImpl
implements CookieBuilder {
    protected final CookieImpl seed;
    protected final InstanceFactory factory;

    public CookieBuilderImpl(String name, InstanceFactory instanceFactory) {
        this.seed = new CookieImpl(name, null);
        this.factory = instanceFactory;
    }

    public CookieBuilder comment(String purpose) {
        this.seed.setComment(purpose);
        return this;
    }

    public CookieBuilder domain(String pattern) {
        this.seed.setDomain(pattern);
        return this;
    }

    public CookieBuilder httpOnly(boolean isHttpOnly) {
        this.seed.setHttpOnly(isHttpOnly);
        return this;
    }

    public CookieBuilder httpOnly() {
        return this.httpOnly(true);
    }

    public CookieBuilder notHttpOnly() {
        return this.httpOnly(false);
    }

    public CookieBuilder maxAge(int expiry) {
        this.seed.setMaxAge(expiry);
        return this;
    }

    public CookieBuilder path(String uri) {
        this.seed.setPath(uri);
        return this;
    }

    public CookieBuilder secure(boolean isSecure) {
        this.seed.setSecure(isSecure);
        return this;
    }

    public CookieBuilder secure() {
        return this.secure(true);
    }

    public CookieBuilder notSecure() {
        return this.secure(false);
    }

    public CookieBuilder value(String value) {
        this.seed.setValue(value);
        return this;
    }

    public CookieBuilder version(int version) {
        this.seed.setVersion(version == 1 ? 1 : 0);
        return this;
    }

    public void write(HttpServletResponse response) {
        if (CookieImpl.isHttpOnlySupported()) {
            response.addCookie(this.create());
        } else {
            response.addHeader("Set-Cookie", this.toHeaderString());
        }
    }

    public Cookie create() {
        return (Cookie)this.seed.clone();
    }

    public String toHeaderString() {
        return this.factory.buildCookieAttribute(this.seed.getVersion()).write(this.seed, this.factory.createCookieFormatter(this.seed.getVersion()));
    }
}

