/*
 * Decompiled with CFR 0.152.
 */
package net.jp.saf.http.cookie.factory.impl;

import net.jp.saf.http.cookie.factory.InstanceFactory;
import net.jp.saf.http.cookie.syntax.CookieAttribute;
import net.jp.saf.http.cookie.syntax.CookieFormatter;
import net.jp.saf.http.cookie.syntax.impl.CommentAttribute;
import net.jp.saf.http.cookie.syntax.impl.CookieFormatterImpl;
import net.jp.saf.http.cookie.syntax.impl.DomainAttribute;
import net.jp.saf.http.cookie.syntax.impl.ExpiresAttribute;
import net.jp.saf.http.cookie.syntax.impl.HttpOnlyAttribute;
import net.jp.saf.http.cookie.syntax.impl.NameAttribute;
import net.jp.saf.http.cookie.syntax.impl.PathAttribute;
import net.jp.saf.http.cookie.syntax.impl.SecureAttribute;
import net.jp.saf.http.cookie.syntax.impl.VersionAttribute;

public class InstanceFactoryImpl
implements InstanceFactory {
    private CookieAttribute version0;
    private CookieAttribute version1;
    private boolean initialized;

    public void initialize() {
        if (this.initialized) {
            return;
        }
        CookieAttribute attr0 = this.buildVersion0CookieAttribute();
        CookieAttribute attr1 = this.buildVersion1CookieAttribute();
        this.version0 = attr0;
        this.version1 = attr1;
        this.initialized = true;
    }

    public CookieFormatter createCookieFormatter(int cookieVersion) {
        return new CookieFormatterImpl();
    }

    public CookieAttribute buildCookieAttribute(int cookieVersion) {
        if (cookieVersion == 0) {
            return this.version0;
        }
        return this.version1;
    }

    protected CookieAttribute buildVersion0CookieAttribute() {
        return this.createNameAttribute(0, this.createExpiresAttribute(0, this.createPathAttribute(0, this.createDomainAttribute(0, this.createSecureAttribute(0, this.createHttpOnlyAttribute(0, null))))));
    }

    protected CookieAttribute buildVersion1CookieAttribute() {
        return this.createNameAttribute(1, this.createExpiresAttribute(1, this.createDomainAttribute(1, this.createPathAttribute(1, this.createSecureAttribute(1, this.createHttpOnlyAttribute(1, this.createCommentAttribute(1, null)))))));
    }

    public CookieAttribute createNameAttribute(int cookieVersion, CookieAttribute nextAttr) {
        return new NameAttribute(nextAttr);
    }

    public CookieAttribute createExpiresAttribute(int cookieVersion, CookieAttribute nextAttr) {
        return new ExpiresAttribute(nextAttr, cookieVersion != 0);
    }

    public CookieAttribute createDomainAttribute(int cookieVersion, CookieAttribute nextAttr) {
        return new DomainAttribute(nextAttr);
    }

    public CookieAttribute createPathAttribute(int cookieVersion, CookieAttribute nextAttr) {
        return new PathAttribute(nextAttr);
    }

    public CookieAttribute createSecureAttribute(int cookieVersion, CookieAttribute nextAttr) {
        return new SecureAttribute(nextAttr);
    }

    public CookieAttribute createHttpOnlyAttribute(int cookieVersion, CookieAttribute nextAttr) {
        return new HttpOnlyAttribute(nextAttr);
    }

    public CookieAttribute createVersionAttribute(int cookieVersion, CookieAttribute nextAttr) {
        return new VersionAttribute(nextAttr);
    }

    public CookieAttribute createCommentAttribute(int cookieVersion, CookieAttribute nextAttr) {
        return new CommentAttribute(nextAttr);
    }
}

