/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.teenyhttpd.response;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.jonathangiles.tools.teenyhttpd.response.Response;
import net.jonathangiles.tools.teenyhttpd.response.StatusCode;

public class ByteResponse
implements Response {
    final StatusCode statusCode;
    final List<String> headers;
    final byte[] body;

    public ByteResponse(StatusCode statusCode) {
        this(statusCode, Collections.emptyList());
    }

    public ByteResponse(StatusCode statusCode, List<String> headers) {
        this(statusCode, headers, null);
    }

    public ByteResponse(StatusCode statusCode, byte[] body) {
        this(statusCode, Collections.emptyList(), body);
    }

    public ByteResponse(StatusCode statusCode, List<String> headers, byte[] body) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
    }

    @Override
    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    @Override
    public List<String> getHeaders() {
        return this.headers;
    }

    @Override
    public long getBodyLength() {
        return this.body == null ? 0L : (long)this.body.length;
    }

    @Override
    public void writeBody(BufferedOutputStream dataOut) throws IOException {
        if (this.body != null) {
            dataOut.write(this.body, 0, this.body.length);
            dataOut.flush();
        }
    }
}

