/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.teenyhttpd.request;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class QueryParams {
    public static final QueryParams EMPTY = new QueryParams("");
    private final String allParams;
    private Map<String, String> map;

    public QueryParams(String allParams) {
        this.allParams = allParams;
    }

    public Map<String, String> getQueryParams() {
        if (this.map == null) {
            if (this.allParams == null || this.allParams.isEmpty()) {
                this.map = Collections.emptyMap();
            } else {
                HashMap<String, String> tempMap = new HashMap<String, String>();
                for (String param : this.allParams.split("&")) {
                    String[] keyValue = param.split("=", 2);
                    try {
                        String value;
                        String key = URLDecoder.decode(keyValue[0], "UTF-8");
                        String string = value = keyValue.length > 1 ? URLDecoder.decode(keyValue[1], "UTF-8") : "";
                        if (key.isEmpty()) continue;
                        tempMap.put(key, value);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                this.map = Collections.unmodifiableMap(tempMap);
            }
        }
        return this.map;
    }

    public String toString() {
        return this.getQueryParams().toString();
    }
}

