/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.teenyhttpd;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jonathangiles.tools.teenyhttpd.request.Header;
import net.jonathangiles.tools.teenyhttpd.request.Method;
import net.jonathangiles.tools.teenyhttpd.request.QueryParams;
import net.jonathangiles.tools.teenyhttpd.request.Request;
import net.jonathangiles.tools.teenyhttpd.response.FileResponse;
import net.jonathangiles.tools.teenyhttpd.response.Response;
import net.jonathangiles.tools.teenyhttpd.response.StatusCode;
import net.jonathangiles.tools.teenyhttpd.response.StringResponse;

public class TeenyHttpd {
    public static final File DEFAULT_WEB_ROOT = new File(Thread.currentThread().getContextClassLoader().getResource("webroot").getFile());
    private final int port;
    private final Supplier<? extends ExecutorService> executorSupplier;
    private ExecutorService executorService;
    private ServerSocket serverSocket;
    private boolean isRunning = false;
    private final Map<Method, Map<RequestPath, Function<Request, Response>>> routes = new HashMap<Method, Map<RequestPath, Function<Request, Response>>>();

    public TeenyHttpd(int port) {
        this(port, Executors::newCachedThreadPool);
    }

    public TeenyHttpd(int port, Supplier<? extends ExecutorService> executorSupplier) {
        this.port = port;
        this.executorSupplier = executorSupplier;
    }

    public void addGetRoute(String path, Function<Request, Response> handler) {
        this.addRoute(Method.GET, path, handler);
    }

    public void addRoute(Method method, String path, Function<Request, Response> handler) {
        this._addRoute(method, path, handler);
    }

    public void addStringRoute(String path, Function<Request, String> handler) {
        this._addRoute(Method.GET, path, request -> new StringResponse((String)handler.apply((Request)request)));
    }

    public void addFileRoute(String path) {
        this.addFileRoute(path, DEFAULT_WEB_ROOT);
    }

    public void addFileRoute(String path, final File webroot) {
        if (path == null) {
            path = "/";
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        this._addRoute(Method.GET, (String)path + "(?<filePath>.*)", request -> new FileResponse((Request)request){

            @Override
            protected File getFile(String filename) {
                return new File(webroot, filename);
            }
        });
    }

    private void _addRoute(Method method, String path, Function<Request, Response> handler) {
        this.routes.computeIfAbsent(method, k -> new HashMap()).put(new RequestPath(path), handler);
    }

    public void start() {
        Thread serverThread = new Thread(this::startServer);
        serverThread.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startServer() {
        System.out.println("TeenyHttp server started.\nListening for connections on port : " + this.port);
        this.isRunning = true;
        this.executorService = this.executorSupplier.get();
        try {
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            while (this.isRunning) {
                Socket clientSocket = this.serverSocket.accept();
                this.executorService.execute(() -> this.handleIncomingRequest(clientSocket));
            }
            return;
        }
        catch (SocketException e) {
            if (!e.getMessage().contains("Socket closed")) return;
        }
        catch (IOException e) {
            System.err.println("Server Connection error : " + e.getMessage());
        }
    }

    public void stop() {
        this.isRunning = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("TeenyHttp server stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleIncomingRequest(Socket clientSocket) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));){
            Response response;
            String line;
            Request request;
            String input = in.readLine();
            if (input == null) {
                return;
            }
            StringTokenizer parse = new StringTokenizer(input);
            Method method = Method.valueOf(parse.nextToken().toUpperCase());
            Map<RequestPath, Function<Request, Response>> methodRoutes = this.routes.get((Object)method);
            String requestUri = parse.nextToken().toLowerCase();
            if (requestUri.contains("?")) {
                String[] uriSplit = requestUri.split("\\?", 2);
                request = new Request(method, uriSplit[0], new QueryParams(uriSplit[1]));
            } else {
                request = new Request(method, requestUri, QueryParams.EMPTY);
            }
            if (methodRoutes == null) {
                boolean isSupportedOnOtherMethods = this.routes.values().stream().flatMap(m -> m.keySet().stream()).anyMatch(p -> p.getPath().equals(request.getPath()));
                if (isSupportedOnOtherMethods) {
                    this.sendStatusCode(clientSocket, StatusCode.METHOD_NOT_ALLOWED);
                    return;
                }
                this.sendStatusCode(clientSocket, StatusCode.NOT_FOUND);
                return;
            }
            while ((line = in.readLine()) != null && !line.isEmpty() && !"\r\n".equals(line)) {
                request.addHeader(new Header(line));
            }
            Optional<Map.Entry> route = methodRoutes.entrySet().stream().filter(entry -> ((RequestPath)entry.getKey()).getRegex().matcher(request.getPath()).matches()).findFirst();
            if (route.isPresent()) {
                RequestPath requestPath = (RequestPath)route.get().getKey();
                Matcher matcher = requestPath.getRegex().matcher(request.getPath());
                if (matcher.matches()) {
                    List<String> pathParams = requestPath.getPathParams();
                    for (int i = 0; i < pathParams.size(); ++i) {
                        request.addPathParam(pathParams.get(i), URLDecoder.decode(matcher.group(i + 1), "UTF-8"));
                    }
                }
                response = (Response)((Function)route.get().getValue()).apply(request);
            } else {
                response = StatusCode.NOT_FOUND.asResponse();
            }
            this.sendResponse(clientSocket, response);
            return;
        }
        catch (IOException e) {
            System.err.println("Server error 2 : " + String.valueOf(e));
            return;
        }
        finally {
            try {
                clientSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendStatusCode(Socket clientSocket, StatusCode statusCode) {
        this.sendResponse(clientSocket, statusCode, null);
    }

    private void sendResponse(Socket clientSocket, Response response) {
        this.sendResponse(clientSocket, null, response);
    }

    private void sendResponse(Socket clientSocket, StatusCode statusCode, Response response) {
        try (PrintWriter out = new PrintWriter(clientSocket.getOutputStream());
             BufferedOutputStream dataOut = new BufferedOutputStream(clientSocket.getOutputStream());){
            out.println((statusCode == null ? response.getStatusCode() : statusCode).toString());
            out.println("Server: TeenyHttpd from JonathanGiles.net : 1.0");
            out.println("Date: " + String.valueOf(LocalDateTime.now()));
            if (response != null) {
                response.getHeaders().forEach(out::println);
                out.println("Content-Length: " + response.getBodyLength());
            }
            out.println();
            out.flush();
            if (response != null) {
                response.writeBody(dataOut);
                dataOut.flush();
            }
        }
        catch (IOException ioe) {
            System.err.println("Server error when trying to serve request");
            System.err.println("Server error : " + String.valueOf(ioe));
        }
    }

    private static class RequestPath {
        private final String path;
        private final Pattern regexPattern;
        private final List<String> pathParams = new ArrayList<String>();

        RequestPath(String path) {
            this.path = path;
            String regexString = path;
            if (path.contains(":")) {
                regexString = RequestPath.replaceTokens(path, Pattern.compile(":[^/]*+"), matcher -> {
                    String paramName = matcher.group().substring(1);
                    return "(?<" + paramName + ">[^/]*+)";
                });
            }
            this.regexPattern = Pattern.compile(regexString, 2);
            Matcher matcher2 = this.regexPattern.matcher(path);
            if (matcher2.find()) {
                for (int i = 1; i <= matcher2.groupCount(); ++i) {
                    this.pathParams.add(matcher2.group(i).substring(1));
                }
            }
        }

        Pattern getRegex() {
            return this.regexPattern;
        }

        String getPath() {
            return this.path;
        }

        List<String> getPathParams() {
            return this.pathParams;
        }

        private static String replaceTokens(String original, Pattern tokenPattern, Function<Matcher, String> converter) {
            int lastIndex = 0;
            StringBuilder output = new StringBuilder();
            Matcher matcher = tokenPattern.matcher(original);
            while (matcher.find()) {
                output.append(original, lastIndex, matcher.start()).append(converter.apply(matcher));
                lastIndex = matcher.end();
            }
            if (lastIndex < original.length()) {
                output.append(original, lastIndex, original.length());
            }
            return output.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestPath that = (RequestPath)o;
            return Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }
    }
}

