/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.teenyhttpd.request;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jonathangiles.tools.teenyhttpd.request.Header;
import net.jonathangiles.tools.teenyhttpd.request.Method;
import net.jonathangiles.tools.teenyhttpd.request.QueryParams;

public class Request {
    private final Method method;
    private final String path;
    private final QueryParams queryParams;
    private List<Header> headers;
    private Map<String, String> headersMap;

    public Request(Method method, String path, QueryParams queryParams) {
        this.method = method;
        this.path = path;
        this.queryParams = queryParams;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public void addHeader(Header header) {
        if (this.headers == null) {
            this.headers = new ArrayList<Header>();
        }
        this.headers.add(header);
    }

    public Map<String, String> getHeaders() {
        if (this.headersMap == null) {
            this.headersMap = new LinkedHashMap<String, String>();
            this.headers.forEach(header -> this.headersMap.put(header.getKey(), header.getValue()));
        }
        return this.headersMap;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams.getQueryParams();
    }

    public String toString() {
        return "Request{method=" + this.method + ", path='" + this.path + "', queryParams=" + this.queryParams + ", headers=" + this.headers + "}";
    }
}

