/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.teenyhttpd.response;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.jonathangiles.tools.teenyhttpd.request.Method;
import net.jonathangiles.tools.teenyhttpd.request.Request;
import net.jonathangiles.tools.teenyhttpd.response.Response;
import net.jonathangiles.tools.teenyhttpd.response.StatusCode;

public class FileResponse
extends Response {
    static final String DEFAULT_FILE = "index.html";
    static final String FILE_NOT_FOUND = "404.html";
    static final String METHOD_NOT_SUPPORTED = "not_supported.html";
    private static final Map<String, String> contentTypes;
    private static final ClassLoader loader;
    private static final File DEFAULT_WEB_ROOT;
    private static final FileNameMap FILE_NAME_MAP;
    private final StatusCode statusCode;
    private final List<String> headers;
    private File fileToReturn;

    public FileResponse(Request request) {
        super(request);
        Method method = this.getRequest().getMethod();
        String path = this.getRequest().getPath();
        this.fileToReturn = null;
        switch (method) {
            case GET: {
                if (path.endsWith("/")) {
                    path = path + DEFAULT_FILE;
                }
                this.fileToReturn = this.getFile(path);
                if (!this.fileToReturn.exists()) {
                    this.fileToReturn = this.getFile(FILE_NOT_FOUND);
                    this.statusCode = StatusCode.NOT_FOUND;
                    break;
                }
                this.statusCode = StatusCode.OK;
                break;
            }
            default: {
                this.fileToReturn = this.getFile(METHOD_NOT_SUPPORTED);
                this.statusCode = StatusCode.NOT_IMPLEMENTED;
            }
        }
        int fileLength = (int)this.fileToReturn.length();
        this.headers = new ArrayList<String>();
        this.headers.add("Content-type: " + this.getContentType(this.fileToReturn));
        this.headers.add("Content-length: " + fileLength);
    }

    @Override
    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    @Override
    public List<String> getHeaders() {
        return this.headers;
    }

    @Override
    public void writeBody(BufferedOutputStream dataOut) throws IOException {
        Files.copy(this.fileToReturn.toPath(), dataOut);
        dataOut.flush();
    }

    private String getContentType(File file) {
        String ext = file.getName().substring(file.getName().lastIndexOf(".") + 1);
        String contentType = contentTypes.get(ext);
        if (contentType != null) {
            return contentType;
        }
        contentType = FILE_NAME_MAP.getContentTypeFor(file.getName());
        if (contentType != null) {
            return contentType;
        }
        System.err.println("Unable to determine content type for file " + file.getName());
        return "text/plain";
    }

    protected File getFile(String filename) {
        return new File(DEFAULT_WEB_ROOT, filename);
    }

    static {
        Properties props = new Properties();
        try (InputStream resourceStream = FileResponse.class.getResourceAsStream("contentTypes.properties");){
            props.load(resourceStream);
        }
        catch (IOException e) {
            props = null;
            e.printStackTrace();
        }
        contentTypes = props == null ? Collections.emptyMap() : (Map)props;
        loader = Thread.currentThread().getContextClassLoader();
        DEFAULT_WEB_ROOT = Paths.get(loader.getResource("webroot").getPath(), new String[0]).toFile();
        FILE_NAME_MAP = URLConnection.getFileNameMap();
    }
}

