/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.teenyhttpd.response;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.jonathangiles.tools.teenyhttpd.request.Request;
import net.jonathangiles.tools.teenyhttpd.response.Response;
import net.jonathangiles.tools.teenyhttpd.response.StatusCode;

public class ByteResponse
extends Response {
    final StatusCode statusCode;
    final List<String> headers;
    final byte[] body;

    public ByteResponse(Request request, StatusCode statusCode) {
        this(request, statusCode, Collections.emptyList());
    }

    public ByteResponse(Request request, StatusCode statusCode, List<String> headers) {
        this(request, statusCode, headers, null);
    }

    public ByteResponse(Request request, StatusCode statusCode, byte[] body) {
        this(request, statusCode, Collections.emptyList(), body);
    }

    public ByteResponse(Request request, StatusCode statusCode, List<String> headers, byte[] body) {
        super(request);
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
    }

    @Override
    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    @Override
    public List<String> getHeaders() {
        return this.headers;
    }

    @Override
    public void writeBody(BufferedOutputStream dataOut) throws IOException {
        if (this.body != null) {
            dataOut.write(this.body, 0, this.body.length);
            dataOut.flush();
        }
    }
}

