/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.teenyhttpd.response;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.jonathangiles.tools.teenyhttpd.request.Method;
import net.jonathangiles.tools.teenyhttpd.request.Request;
import net.jonathangiles.tools.teenyhttpd.response.Response;
import net.jonathangiles.tools.teenyhttpd.response.StatusCode;

public class FileResponse
extends Response {
    static final String DEFAULT_FILE = "index.html";
    static final String FILE_NOT_FOUND = "404.html";
    static final String METHOD_NOT_SUPPORTED = "not_supported.html";
    private static final ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private static final File DEFAULT_WEB_ROOT = Paths.get(loader.getResource("webroot").getPath(), new String[0]).toFile();
    private final StatusCode statusCode;
    private final List<String> headers;
    private File fileToReturn;

    public FileResponse(Request request) {
        super(request);
        Method method = this.getRequest().getMethod();
        String path = this.getRequest().getPath();
        this.fileToReturn = null;
        switch (method) {
            case GET: {
                if (path.endsWith("/")) {
                    path = path + DEFAULT_FILE;
                }
                this.fileToReturn = this.getFile(path);
                if (!this.fileToReturn.exists()) {
                    this.fileToReturn = this.getFile(FILE_NOT_FOUND);
                    this.statusCode = StatusCode.NOT_FOUND;
                    break;
                }
                this.statusCode = StatusCode.OK;
                break;
            }
            default: {
                this.fileToReturn = this.getFile(METHOD_NOT_SUPPORTED);
                this.statusCode = StatusCode.NOT_IMPLEMENTED;
            }
        }
        int fileLength = (int)this.fileToReturn.length();
        this.headers = new ArrayList<String>();
        this.headers.add("Content-type: " + this.getContentType(this.fileToReturn));
        this.headers.add("Content-length: " + fileLength);
    }

    @Override
    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    @Override
    public List<String> getHeaders() {
        return this.headers;
    }

    @Override
    public void writeBody(BufferedOutputStream dataOut) throws IOException {
        Files.copy(this.fileToReturn.toPath(), dataOut);
        dataOut.flush();
    }

    private String getContentType(File file) {
        String filename = file.getName();
        if (filename.endsWith(".htm") || filename.endsWith(".html")) {
            return "text/html";
        }
        return "text/plain";
    }

    protected File getFile(String filename) {
        return new File(DEFAULT_WEB_ROOT, filename);
    }
}

