/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.teenyhttpd;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.time.LocalDateTime;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import net.jonathangiles.tools.teenyhttpd.request.Header;
import net.jonathangiles.tools.teenyhttpd.request.Method;
import net.jonathangiles.tools.teenyhttpd.request.QueryParams;
import net.jonathangiles.tools.teenyhttpd.request.Request;
import net.jonathangiles.tools.teenyhttpd.response.FileResponse;
import net.jonathangiles.tools.teenyhttpd.response.Response;

public class TeenyHttpd {
    private final int port;
    private final Supplier<? extends ExecutorService> executorSupplier;
    private ExecutorService executorService;
    private boolean isRunning = false;
    private File webroot;

    public TeenyHttpd(int port) {
        this(port, Executors::newSingleThreadExecutor);
    }

    public TeenyHttpd(int port, Supplier<? extends ExecutorService> executorSupplier) {
        this.port = port;
        this.executorSupplier = executorSupplier;
    }

    public void setWebroot(File webroot) {
        this.webroot = webroot;
    }

    public void start() {
        System.out.println("TeenyHttp server started.\nListening for connections on port : " + this.port + " ...\n");
        this.isRunning = true;
        this.executorService = this.executorSupplier.get();
        try (ServerSocket serverSocket = new ServerSocket(this.port);){
            while (this.isRunning) {
                Socket connect = serverSocket.accept();
                this.executorService.execute(() -> this.run(connect));
            }
        }
        catch (IOException e) {
            System.err.println("Server Connection error : " + e.getMessage());
        }
    }

    public void stop() {
        this.isRunning = false;
        this.executorService.shutdown();
    }

    public Response serve(Request request) {
        return new FileResponse(request){

            @Override
            protected File getFile(String filename) {
                return new File(TeenyHttpd.this.webroot, filename);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Socket connect) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connect.getInputStream()));
             PrintWriter out = new PrintWriter(connect.getOutputStream());
             BufferedOutputStream dataOut = new BufferedOutputStream(connect.getOutputStream());){
            String line;
            Request request;
            String input = in.readLine();
            if (input == null) {
                return;
            }
            StringTokenizer parse = new StringTokenizer(input);
            Method method = Method.valueOf(parse.nextToken().toUpperCase());
            String requestUri = parse.nextToken().toLowerCase();
            if (requestUri.contains("?")) {
                String[] uriSplit = requestUri.split("\\?", 2);
                request = new Request(method, uriSplit[0], new QueryParams(uriSplit[1]));
            } else {
                request = new Request(method, requestUri, QueryParams.EMPTY);
            }
            while ((line = in.readLine()) != null && !line.isEmpty() && !"\r\n".equals(line)) {
                request.addHeader(new Header(line));
            }
            Response response = this.serve(request);
            if (response != null) {
                out.println(response.getStatusCode().toString());
                out.println("Server: TeenyHttpd from JonathanGiles.net : 1.0");
                out.println("Date: " + LocalDateTime.now());
                response.getHeaders().forEach(out::println);
                out.println();
                out.flush();
                response.writeBody(dataOut);
            }
        }
        catch (IOException ioe) {
            System.err.println("Server error : " + ioe);
        }
        finally {
            try {
                connect.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

