/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tools.sitebuilder.util;

import java.io.File;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.jonathangiles.tools.sitebuilder.SiteBuilder;
import net.jonathangiles.tools.sitebuilder.models.SiteContent;

public class SitePaths {
    private SitePaths() {
    }

    public static Path createRelativePath(Path basePath, Path file) {
        return new File(SiteBuilder.OUTPUT_DIR, basePath.relativize(file).toString()).toPath();
    }

    public static String createRelativePath(Path path) {
        String pathStr = path.toString();
        return pathStr.substring(pathStr.indexOf("target/output/") + "target/output".length() + 1);
    }

    public static Consumer<SiteContent> createSlugDirStructure(String prefix, boolean createYearDirs) {
        return siteContent -> {
            Path fullOutputPath;
            String slug = siteContent.getSlug();
            String relativePath = prefix + (String)(createYearDirs ? siteContent.getDate().getYear() + "/" : "");
            if (slug.startsWith("/")) {
                fullOutputPath = new File(SiteBuilder.OUTPUT_DIR, relativePath + "/" + slug + ".html").toPath();
            } else {
                relativePath = relativePath + slug;
                fullOutputPath = new File(SiteBuilder.OUTPUT_DIR, relativePath + "/index.html").toPath();
            }
            siteContent.setRelativePath(relativePath);
            siteContent.setFullOutputPath(fullOutputPath);
        };
    }
}

